package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QuotaUsageBuilder extends QuotaUsageFluent<QuotaUsageBuilder> implements VisitableBuilder<QuotaUsage,QuotaUsageBuilder>{
  public QuotaUsageBuilder() {
    this(new QuotaUsage());
  }
  
  public QuotaUsageBuilder(QuotaUsageFluent<?> fluent) {
    this(fluent, new QuotaUsage());
  }
  
  public QuotaUsageBuilder(QuotaUsageFluent<?> fluent,QuotaUsage instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QuotaUsageBuilder(QuotaUsage instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QuotaUsageFluent<?> fluent;
  
  public QuotaUsage build() {
    QuotaUsage buildable = new QuotaUsage(fluent.getAmount(),fluent.getDimensions(),fluent.getLimit(),fluent.getService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}