package io.fabric8.openshift.api.model.installer.openstack.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RootVolumeFluent<A extends RootVolumeFluent<A>> extends BaseFluent<A>{
  public RootVolumeFluent() {
  }
  
  public RootVolumeFluent(RootVolume instance) {
    this.copyInstance(instance);
  }
  private Integer size;
  private String type;
  private List<String> types = new ArrayList<String>();
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RootVolume instance) {
    instance = (instance != null ? instance : new RootVolume());
    if (instance != null) {
          this.withSize(instance.getSize());
          this.withType(instance.getType());
          this.withTypes(instance.getTypes());
          this.withZones(instance.getZones());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getSize() {
    return this.size;
  }
  
  public A withSize(Integer size) {
    this.size = size;
    return (A) this;
  }
  
  public boolean hasSize() {
    return this.size != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToTypes(int index,String item) {
    if (this.types == null) {this.types = new ArrayList<String>();}
    this.types.add(index, item);
    return (A)this;
  }
  
  public A setToTypes(int index,String item) {
    if (this.types == null) {this.types = new ArrayList<String>();}
    this.types.set(index, item); return (A)this;
  }
  
  public A addToTypes(java.lang.String... items) {
    if (this.types == null) {this.types = new ArrayList<String>();}
    for (String item : items) {this.types.add(item);} return (A)this;
  }
  
  public A addAllToTypes(Collection<String> items) {
    if (this.types == null) {this.types = new ArrayList<String>();}
    for (String item : items) {this.types.add(item);} return (A)this;
  }
  
  public A removeFromTypes(java.lang.String... items) {
    if (this.types == null) return (A)this;
    for (String item : items) { this.types.remove(item);} return (A)this;
  }
  
  public A removeAllFromTypes(Collection<String> items) {
    if (this.types == null) return (A)this;
    for (String item : items) { this.types.remove(item);} return (A)this;
  }
  
  public List<String> getTypes() {
    return this.types;
  }
  
  public String getType(int index) {
    return this.types.get(index);
  }
  
  public String getFirstType() {
    return this.types.get(0);
  }
  
  public String getLastType() {
    return this.types.get(types.size() - 1);
  }
  
  public String getMatchingType(Predicate<String> predicate) {
      for (String item : types) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingType(Predicate<String> predicate) {
      for (String item : types) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTypes(List<String> types) {
    if (types != null) {
        this.types = new ArrayList();
        for (String item : types) {
          this.addToTypes(item);
        }
    } else {
      this.types = null;
    }
    return (A) this;
  }
  
  public A withTypes(java.lang.String... types) {
    if (this.types != null) {
        this.types.clear();
        _visitables.remove("types");
    }
    if (types != null) {
      for (String item : types) {
        this.addToTypes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTypes() {
    return this.types != null && !this.types.isEmpty();
  }
  
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A removeFromZones(java.lang.String... items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public A removeAllFromZones(Collection<String> items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public List<String> getZones() {
    return this.zones;
  }
  
  public String getZone(int index) {
    return this.zones.get(index);
  }
  
  public String getFirstZone() {
    return this.zones.get(0);
  }
  
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  
  public String getMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withZones(List<String> zones) {
    if (zones != null) {
        this.zones = new ArrayList();
        for (String item : zones) {
          this.addToZones(item);
        }
    } else {
      this.zones = null;
    }
    return (A) this;
  }
  
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {
        this.zones.clear();
        _visitables.remove("zones");
    }
    if (zones != null) {
      for (String item : zones) {
        this.addToZones(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasZones() {
    return this.zones != null && !this.zones.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RootVolumeFluent that = (RootVolumeFluent) o;
    if (!java.util.Objects.equals(size, that.size)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(types, that.types)) return false;
    if (!java.util.Objects.equals(zones, that.zones)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(size,  type,  types,  zones,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (types != null && !types.isEmpty()) { sb.append("types:"); sb.append(types + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}