package io.fabric8.openshift.api.model.installer.powervs.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ZoneFluent<A extends ZoneFluent<A>> extends BaseFluent<A>{
  public ZoneFluent() {
  }
  
  public ZoneFluent(Zone instance) {
    this.copyInstance(instance);
  }
  private List<String> sysTypes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Zone instance) {
    instance = (instance != null ? instance : new Zone());
    if (instance != null) {
          this.withSysTypes(instance.getSysTypes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToSysTypes(int index,String item) {
    if (this.sysTypes == null) {this.sysTypes = new ArrayList<String>();}
    this.sysTypes.add(index, item);
    return (A)this;
  }
  
  public A setToSysTypes(int index,String item) {
    if (this.sysTypes == null) {this.sysTypes = new ArrayList<String>();}
    this.sysTypes.set(index, item); return (A)this;
  }
  
  public A addToSysTypes(java.lang.String... items) {
    if (this.sysTypes == null) {this.sysTypes = new ArrayList<String>();}
    for (String item : items) {this.sysTypes.add(item);} return (A)this;
  }
  
  public A addAllToSysTypes(Collection<String> items) {
    if (this.sysTypes == null) {this.sysTypes = new ArrayList<String>();}
    for (String item : items) {this.sysTypes.add(item);} return (A)this;
  }
  
  public A removeFromSysTypes(java.lang.String... items) {
    if (this.sysTypes == null) return (A)this;
    for (String item : items) { this.sysTypes.remove(item);} return (A)this;
  }
  
  public A removeAllFromSysTypes(Collection<String> items) {
    if (this.sysTypes == null) return (A)this;
    for (String item : items) { this.sysTypes.remove(item);} return (A)this;
  }
  
  public List<String> getSysTypes() {
    return this.sysTypes;
  }
  
  public String getSysType(int index) {
    return this.sysTypes.get(index);
  }
  
  public String getFirstSysType() {
    return this.sysTypes.get(0);
  }
  
  public String getLastSysType() {
    return this.sysTypes.get(sysTypes.size() - 1);
  }
  
  public String getMatchingSysType(Predicate<String> predicate) {
      for (String item : sysTypes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingSysType(Predicate<String> predicate) {
      for (String item : sysTypes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSysTypes(List<String> sysTypes) {
    if (sysTypes != null) {
        this.sysTypes = new ArrayList();
        for (String item : sysTypes) {
          this.addToSysTypes(item);
        }
    } else {
      this.sysTypes = null;
    }
    return (A) this;
  }
  
  public A withSysTypes(java.lang.String... sysTypes) {
    if (this.sysTypes != null) {
        this.sysTypes.clear();
        _visitables.remove("sysTypes");
    }
    if (sysTypes != null) {
      for (String item : sysTypes) {
        this.addToSysTypes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSysTypes() {
    return this.sysTypes != null && !this.sysTypes.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ZoneFluent that = (ZoneFluent) o;
    if (!java.util.Objects.equals(sysTypes, that.sysTypes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(sysTypes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sysTypes != null && !sysTypes.isEmpty()) { sb.append("sysTypes:"); sb.append(sysTypes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}