package io.fabric8.openshift.api.model.installer.v1;

import java.lang.SuppressWarnings;
import io.fabric8.openshift.api.model.installer.aws.v1.MetadataFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.aws.v1.Metadata;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.CustomFeatureGates;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.installer.aws.v1.MetadataBuilder;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterMetadataFluent<A extends ClusterMetadataFluent<A>> extends BaseFluent<A>{
  public ClusterMetadataFluent() {
  }
  
  public ClusterMetadataFluent(ClusterMetadata instance) {
    this.copyInstance(instance);
  }
  private MetadataBuilder aws;
  private io.fabric8.openshift.api.model.installer.azure.v1.MetadataBuilder azure;
  private io.fabric8.openshift.api.model.installer.baremetal.v1.MetadataBuilder baremetal;
  private String clusterID;
  private String clusterName;
  private CustomFeatureGates customFeatureSet;
  private String featureSet;
  private io.fabric8.openshift.api.model.installer.gcp.v1.MetadataBuilder gcp;
  private io.fabric8.openshift.api.model.installer.ibmcloud.v1.MetadataBuilder ibmcloud;
  private String infraID;
  private io.fabric8.openshift.api.model.installer.nutanix.v1.MetadataBuilder nutanix;
  private io.fabric8.openshift.api.model.installer.openstack.v1.MetadataBuilder openstack;
  private io.fabric8.openshift.api.model.installer.ovirt.v1.MetadataBuilder ovirt;
  private io.fabric8.openshift.api.model.installer.powervs.v1.MetadataBuilder powervs;
  private io.fabric8.openshift.api.model.installer.vsphere.v1.MetadataBuilder vsphere;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterMetadata instance) {
    instance = (instance != null ? instance : new ClusterMetadata());
    if (instance != null) {
          this.withAws(instance.getAws());
          this.withAzure(instance.getAzure());
          this.withBaremetal(instance.getBaremetal());
          this.withClusterID(instance.getClusterID());
          this.withClusterName(instance.getClusterName());
          this.withCustomFeatureSet(instance.getCustomFeatureSet());
          this.withFeatureSet(instance.getFeatureSet());
          this.withGcp(instance.getGcp());
          this.withIbmcloud(instance.getIbmcloud());
          this.withInfraID(instance.getInfraID());
          this.withNutanix(instance.getNutanix());
          this.withOpenstack(instance.getOpenstack());
          this.withOvirt(instance.getOvirt());
          this.withPowervs(instance.getPowervs());
          this.withVsphere(instance.getVsphere());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Metadata buildAws() {
    return this.aws != null ? this.aws.build() : null;
  }
  
  public A withAws(Metadata aws) {
    this._visitables.remove("aws");
    if (aws != null) {
        this.aws = new MetadataBuilder(aws);
        this._visitables.get("aws").add(this.aws);
    } else {
        this.aws = null;
        this._visitables.get("aws").remove(this.aws);
    }
    return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(Metadata item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new MetadataBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(Metadata item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.installer.azure.v1.Metadata buildAzure() {
    return this.azure != null ? this.azure.build() : null;
  }
  
  public A withAzure(io.fabric8.openshift.api.model.installer.azure.v1.Metadata azure) {
    this._visitables.remove("azure");
    if (azure != null) {
        this.azure = new io.fabric8.openshift.api.model.installer.azure.v1.MetadataBuilder(azure);
        this._visitables.get("azure").add(this.azure);
    } else {
        this.azure = null;
        this._visitables.get("azure").remove(this.azure);
    }
    return (A) this;
  }
  
  public boolean hasAzure() {
    return this.azure != null;
  }
  
  public AzureNested<A> withNewAzure() {
    return new AzureNested(null);
  }
  
  public AzureNested<A> withNewAzureLike(io.fabric8.openshift.api.model.installer.azure.v1.Metadata item) {
    return new AzureNested(item);
  }
  
  public AzureNested<A> editAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(null));
  }
  
  public AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(new io.fabric8.openshift.api.model.installer.azure.v1.MetadataBuilder().build()));
  }
  
  public AzureNested<A> editOrNewAzureLike(io.fabric8.openshift.api.model.installer.azure.v1.Metadata item) {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.installer.baremetal.v1.Metadata buildBaremetal() {
    return this.baremetal != null ? this.baremetal.build() : null;
  }
  
  public A withBaremetal(io.fabric8.openshift.api.model.installer.baremetal.v1.Metadata baremetal) {
    this._visitables.remove("baremetal");
    if (baremetal != null) {
        this.baremetal = new io.fabric8.openshift.api.model.installer.baremetal.v1.MetadataBuilder(baremetal);
        this._visitables.get("baremetal").add(this.baremetal);
    } else {
        this.baremetal = null;
        this._visitables.get("baremetal").remove(this.baremetal);
    }
    return (A) this;
  }
  
  public boolean hasBaremetal() {
    return this.baremetal != null;
  }
  
  public A withNewBaremetal(String bootstrapProvisioningIP,String libvirtURI,String provisioningHostIP) {
    return (A)withBaremetal(new io.fabric8.openshift.api.model.installer.baremetal.v1.Metadata(bootstrapProvisioningIP, libvirtURI, provisioningHostIP));
  }
  
  public BaremetalNested<A> withNewBaremetal() {
    return new BaremetalNested(null);
  }
  
  public BaremetalNested<A> withNewBaremetalLike(io.fabric8.openshift.api.model.installer.baremetal.v1.Metadata item) {
    return new BaremetalNested(item);
  }
  
  public BaremetalNested<A> editBaremetal() {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(null));
  }
  
  public BaremetalNested<A> editOrNewBaremetal() {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(new io.fabric8.openshift.api.model.installer.baremetal.v1.MetadataBuilder().build()));
  }
  
  public BaremetalNested<A> editOrNewBaremetalLike(io.fabric8.openshift.api.model.installer.baremetal.v1.Metadata item) {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(item));
  }
  
  public String getClusterID() {
    return this.clusterID;
  }
  
  public A withClusterID(String clusterID) {
    this.clusterID = clusterID;
    return (A) this;
  }
  
  public boolean hasClusterID() {
    return this.clusterID != null;
  }
  
  public String getClusterName() {
    return this.clusterName;
  }
  
  public A withClusterName(String clusterName) {
    this.clusterName = clusterName;
    return (A) this;
  }
  
  public boolean hasClusterName() {
    return this.clusterName != null;
  }
  
  public CustomFeatureGates getCustomFeatureSet() {
    return this.customFeatureSet;
  }
  
  public A withCustomFeatureSet(CustomFeatureGates customFeatureSet) {
    this.customFeatureSet = customFeatureSet;
    return (A) this;
  }
  
  public boolean hasCustomFeatureSet() {
    return this.customFeatureSet != null;
  }
  
  public String getFeatureSet() {
    return this.featureSet;
  }
  
  public A withFeatureSet(String featureSet) {
    this.featureSet = featureSet;
    return (A) this;
  }
  
  public boolean hasFeatureSet() {
    return this.featureSet != null;
  }
  
  public io.fabric8.openshift.api.model.installer.gcp.v1.Metadata buildGcp() {
    return this.gcp != null ? this.gcp.build() : null;
  }
  
  public A withGcp(io.fabric8.openshift.api.model.installer.gcp.v1.Metadata gcp) {
    this._visitables.remove("gcp");
    if (gcp != null) {
        this.gcp = new io.fabric8.openshift.api.model.installer.gcp.v1.MetadataBuilder(gcp);
        this._visitables.get("gcp").add(this.gcp);
    } else {
        this.gcp = null;
        this._visitables.get("gcp").remove(this.gcp);
    }
    return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null;
  }
  
  public A withNewGcp(String networkProjectID,String privateZoneDomain,String projectID,String region) {
    return (A)withGcp(new io.fabric8.openshift.api.model.installer.gcp.v1.Metadata(networkProjectID, privateZoneDomain, projectID, region));
  }
  
  public GcpNested<A> withNewGcp() {
    return new GcpNested(null);
  }
  
  public GcpNested<A> withNewGcpLike(io.fabric8.openshift.api.model.installer.gcp.v1.Metadata item) {
    return new GcpNested(item);
  }
  
  public GcpNested<A> editGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  
  public GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new io.fabric8.openshift.api.model.installer.gcp.v1.MetadataBuilder().build()));
  }
  
  public GcpNested<A> editOrNewGcpLike(io.fabric8.openshift.api.model.installer.gcp.v1.Metadata item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.installer.ibmcloud.v1.Metadata buildIbmcloud() {
    return this.ibmcloud != null ? this.ibmcloud.build() : null;
  }
  
  public A withIbmcloud(io.fabric8.openshift.api.model.installer.ibmcloud.v1.Metadata ibmcloud) {
    this._visitables.remove("ibmcloud");
    if (ibmcloud != null) {
        this.ibmcloud = new io.fabric8.openshift.api.model.installer.ibmcloud.v1.MetadataBuilder(ibmcloud);
        this._visitables.get("ibmcloud").add(this.ibmcloud);
    } else {
        this.ibmcloud = null;
        this._visitables.get("ibmcloud").remove(this.ibmcloud);
    }
    return (A) this;
  }
  
  public boolean hasIbmcloud() {
    return this.ibmcloud != null;
  }
  
  public IbmcloudNested<A> withNewIbmcloud() {
    return new IbmcloudNested(null);
  }
  
  public IbmcloudNested<A> withNewIbmcloudLike(io.fabric8.openshift.api.model.installer.ibmcloud.v1.Metadata item) {
    return new IbmcloudNested(item);
  }
  
  public IbmcloudNested<A> editIbmcloud() {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(null));
  }
  
  public IbmcloudNested<A> editOrNewIbmcloud() {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(new io.fabric8.openshift.api.model.installer.ibmcloud.v1.MetadataBuilder().build()));
  }
  
  public IbmcloudNested<A> editOrNewIbmcloudLike(io.fabric8.openshift.api.model.installer.ibmcloud.v1.Metadata item) {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(item));
  }
  
  public String getInfraID() {
    return this.infraID;
  }
  
  public A withInfraID(String infraID) {
    this.infraID = infraID;
    return (A) this;
  }
  
  public boolean hasInfraID() {
    return this.infraID != null;
  }
  
  public io.fabric8.openshift.api.model.installer.nutanix.v1.Metadata buildNutanix() {
    return this.nutanix != null ? this.nutanix.build() : null;
  }
  
  public A withNutanix(io.fabric8.openshift.api.model.installer.nutanix.v1.Metadata nutanix) {
    this._visitables.remove("nutanix");
    if (nutanix != null) {
        this.nutanix = new io.fabric8.openshift.api.model.installer.nutanix.v1.MetadataBuilder(nutanix);
        this._visitables.get("nutanix").add(this.nutanix);
    } else {
        this.nutanix = null;
        this._visitables.get("nutanix").remove(this.nutanix);
    }
    return (A) this;
  }
  
  public boolean hasNutanix() {
    return this.nutanix != null;
  }
  
  public A withNewNutanix(String password,String port,String prismCentral,String username) {
    return (A)withNutanix(new io.fabric8.openshift.api.model.installer.nutanix.v1.Metadata(password, port, prismCentral, username));
  }
  
  public NutanixNested<A> withNewNutanix() {
    return new NutanixNested(null);
  }
  
  public NutanixNested<A> withNewNutanixLike(io.fabric8.openshift.api.model.installer.nutanix.v1.Metadata item) {
    return new NutanixNested(item);
  }
  
  public NutanixNested<A> editNutanix() {
    return withNewNutanixLike(java.util.Optional.ofNullable(buildNutanix()).orElse(null));
  }
  
  public NutanixNested<A> editOrNewNutanix() {
    return withNewNutanixLike(java.util.Optional.ofNullable(buildNutanix()).orElse(new io.fabric8.openshift.api.model.installer.nutanix.v1.MetadataBuilder().build()));
  }
  
  public NutanixNested<A> editOrNewNutanixLike(io.fabric8.openshift.api.model.installer.nutanix.v1.Metadata item) {
    return withNewNutanixLike(java.util.Optional.ofNullable(buildNutanix()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.installer.openstack.v1.Metadata buildOpenstack() {
    return this.openstack != null ? this.openstack.build() : null;
  }
  
  public A withOpenstack(io.fabric8.openshift.api.model.installer.openstack.v1.Metadata openstack) {
    this._visitables.remove("openstack");
    if (openstack != null) {
        this.openstack = new io.fabric8.openshift.api.model.installer.openstack.v1.MetadataBuilder(openstack);
        this._visitables.get("openstack").add(this.openstack);
    } else {
        this.openstack = null;
        this._visitables.get("openstack").remove(this.openstack);
    }
    return (A) this;
  }
  
  public boolean hasOpenstack() {
    return this.openstack != null;
  }
  
  public OpenstackNested<A> withNewOpenstack() {
    return new OpenstackNested(null);
  }
  
  public OpenstackNested<A> withNewOpenstackLike(io.fabric8.openshift.api.model.installer.openstack.v1.Metadata item) {
    return new OpenstackNested(item);
  }
  
  public OpenstackNested<A> editOpenstack() {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(null));
  }
  
  public OpenstackNested<A> editOrNewOpenstack() {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(new io.fabric8.openshift.api.model.installer.openstack.v1.MetadataBuilder().build()));
  }
  
  public OpenstackNested<A> editOrNewOpenstackLike(io.fabric8.openshift.api.model.installer.openstack.v1.Metadata item) {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.installer.ovirt.v1.Metadata buildOvirt() {
    return this.ovirt != null ? this.ovirt.build() : null;
  }
  
  public A withOvirt(io.fabric8.openshift.api.model.installer.ovirt.v1.Metadata ovirt) {
    this._visitables.remove("ovirt");
    if (ovirt != null) {
        this.ovirt = new io.fabric8.openshift.api.model.installer.ovirt.v1.MetadataBuilder(ovirt);
        this._visitables.get("ovirt").add(this.ovirt);
    } else {
        this.ovirt = null;
        this._visitables.get("ovirt").remove(this.ovirt);
    }
    return (A) this;
  }
  
  public boolean hasOvirt() {
    return this.ovirt != null;
  }
  
  public A withNewOvirt(String clusterId,Boolean removeTemplate) {
    return (A)withOvirt(new io.fabric8.openshift.api.model.installer.ovirt.v1.Metadata(clusterId, removeTemplate));
  }
  
  public OvirtNested<A> withNewOvirt() {
    return new OvirtNested(null);
  }
  
  public OvirtNested<A> withNewOvirtLike(io.fabric8.openshift.api.model.installer.ovirt.v1.Metadata item) {
    return new OvirtNested(item);
  }
  
  public OvirtNested<A> editOvirt() {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(null));
  }
  
  public OvirtNested<A> editOrNewOvirt() {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(new io.fabric8.openshift.api.model.installer.ovirt.v1.MetadataBuilder().build()));
  }
  
  public OvirtNested<A> editOrNewOvirtLike(io.fabric8.openshift.api.model.installer.ovirt.v1.Metadata item) {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.installer.powervs.v1.Metadata buildPowervs() {
    return this.powervs != null ? this.powervs.build() : null;
  }
  
  public A withPowervs(io.fabric8.openshift.api.model.installer.powervs.v1.Metadata powervs) {
    this._visitables.remove("powervs");
    if (powervs != null) {
        this.powervs = new io.fabric8.openshift.api.model.installer.powervs.v1.MetadataBuilder(powervs);
        this._visitables.get("powervs").add(this.powervs);
    } else {
        this.powervs = null;
        this._visitables.get("powervs").remove(this.powervs);
    }
    return (A) this;
  }
  
  public boolean hasPowervs() {
    return this.powervs != null;
  }
  
  public PowervsNested<A> withNewPowervs() {
    return new PowervsNested(null);
  }
  
  public PowervsNested<A> withNewPowervsLike(io.fabric8.openshift.api.model.installer.powervs.v1.Metadata item) {
    return new PowervsNested(item);
  }
  
  public PowervsNested<A> editPowervs() {
    return withNewPowervsLike(java.util.Optional.ofNullable(buildPowervs()).orElse(null));
  }
  
  public PowervsNested<A> editOrNewPowervs() {
    return withNewPowervsLike(java.util.Optional.ofNullable(buildPowervs()).orElse(new io.fabric8.openshift.api.model.installer.powervs.v1.MetadataBuilder().build()));
  }
  
  public PowervsNested<A> editOrNewPowervsLike(io.fabric8.openshift.api.model.installer.powervs.v1.Metadata item) {
    return withNewPowervsLike(java.util.Optional.ofNullable(buildPowervs()).orElse(item));
  }
  
  public io.fabric8.openshift.api.model.installer.vsphere.v1.Metadata buildVsphere() {
    return this.vsphere != null ? this.vsphere.build() : null;
  }
  
  public A withVsphere(io.fabric8.openshift.api.model.installer.vsphere.v1.Metadata vsphere) {
    this._visitables.remove("vsphere");
    if (vsphere != null) {
        this.vsphere = new io.fabric8.openshift.api.model.installer.vsphere.v1.MetadataBuilder(vsphere);
        this._visitables.get("vsphere").add(this.vsphere);
    } else {
        this.vsphere = null;
        this._visitables.get("vsphere").remove(this.vsphere);
    }
    return (A) this;
  }
  
  public boolean hasVsphere() {
    return this.vsphere != null;
  }
  
  public VsphereNested<A> withNewVsphere() {
    return new VsphereNested(null);
  }
  
  public VsphereNested<A> withNewVsphereLike(io.fabric8.openshift.api.model.installer.vsphere.v1.Metadata item) {
    return new VsphereNested(item);
  }
  
  public VsphereNested<A> editVsphere() {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(null));
  }
  
  public VsphereNested<A> editOrNewVsphere() {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(new io.fabric8.openshift.api.model.installer.vsphere.v1.MetadataBuilder().build()));
  }
  
  public VsphereNested<A> editOrNewVsphereLike(io.fabric8.openshift.api.model.installer.vsphere.v1.Metadata item) {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterMetadataFluent that = (ClusterMetadataFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;
    if (!java.util.Objects.equals(azure, that.azure)) return false;
    if (!java.util.Objects.equals(baremetal, that.baremetal)) return false;
    if (!java.util.Objects.equals(clusterID, that.clusterID)) return false;
    if (!java.util.Objects.equals(clusterName, that.clusterName)) return false;
    if (!java.util.Objects.equals(customFeatureSet, that.customFeatureSet)) return false;
    if (!java.util.Objects.equals(featureSet, that.featureSet)) return false;
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
    if (!java.util.Objects.equals(ibmcloud, that.ibmcloud)) return false;
    if (!java.util.Objects.equals(infraID, that.infraID)) return false;
    if (!java.util.Objects.equals(nutanix, that.nutanix)) return false;
    if (!java.util.Objects.equals(openstack, that.openstack)) return false;
    if (!java.util.Objects.equals(ovirt, that.ovirt)) return false;
    if (!java.util.Objects.equals(powervs, that.powervs)) return false;
    if (!java.util.Objects.equals(vsphere, that.vsphere)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aws,  azure,  baremetal,  clusterID,  clusterName,  customFeatureSet,  featureSet,  gcp,  ibmcloud,  infraID,  nutanix,  openstack,  ovirt,  powervs,  vsphere,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (baremetal != null) { sb.append("baremetal:"); sb.append(baremetal + ","); }
    if (clusterID != null) { sb.append("clusterID:"); sb.append(clusterID + ","); }
    if (clusterName != null) { sb.append("clusterName:"); sb.append(clusterName + ","); }
    if (customFeatureSet != null) { sb.append("customFeatureSet:"); sb.append(customFeatureSet + ","); }
    if (featureSet != null) { sb.append("featureSet:"); sb.append(featureSet + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (ibmcloud != null) { sb.append("ibmcloud:"); sb.append(ibmcloud + ","); }
    if (infraID != null) { sb.append("infraID:"); sb.append(infraID + ","); }
    if (nutanix != null) { sb.append("nutanix:"); sb.append(nutanix + ","); }
    if (openstack != null) { sb.append("openstack:"); sb.append(openstack + ","); }
    if (ovirt != null) { sb.append("ovirt:"); sb.append(ovirt + ","); }
    if (powervs != null) { sb.append("powervs:"); sb.append(powervs + ","); }
    if (vsphere != null) { sb.append("vsphere:"); sb.append(vsphere + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsNested<N> extends MetadataFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(Metadata item) {
      this.builder = new MetadataBuilder(this, item);
    }
    MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }
  public class AzureNested<N> extends io.fabric8.openshift.api.model.installer.azure.v1.MetadataFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(io.fabric8.openshift.api.model.installer.azure.v1.Metadata item) {
      this.builder = new io.fabric8.openshift.api.model.installer.azure.v1.MetadataBuilder(this, item);
    }
    io.fabric8.openshift.api.model.installer.azure.v1.MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withAzure(builder.build());
    }
    
    public N endAzure() {
      return and();
    }
    
  
  }
  public class BaremetalNested<N> extends io.fabric8.openshift.api.model.installer.baremetal.v1.MetadataFluent<BaremetalNested<N>> implements Nested<N>{
    BaremetalNested(io.fabric8.openshift.api.model.installer.baremetal.v1.Metadata item) {
      this.builder = new io.fabric8.openshift.api.model.installer.baremetal.v1.MetadataBuilder(this, item);
    }
    io.fabric8.openshift.api.model.installer.baremetal.v1.MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withBaremetal(builder.build());
    }
    
    public N endBaremetal() {
      return and();
    }
    
  
  }
  public class GcpNested<N> extends io.fabric8.openshift.api.model.installer.gcp.v1.MetadataFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(io.fabric8.openshift.api.model.installer.gcp.v1.Metadata item) {
      this.builder = new io.fabric8.openshift.api.model.installer.gcp.v1.MetadataBuilder(this, item);
    }
    io.fabric8.openshift.api.model.installer.gcp.v1.MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withGcp(builder.build());
    }
    
    public N endGcp() {
      return and();
    }
    
  
  }
  public class IbmcloudNested<N> extends io.fabric8.openshift.api.model.installer.ibmcloud.v1.MetadataFluent<IbmcloudNested<N>> implements Nested<N>{
    IbmcloudNested(io.fabric8.openshift.api.model.installer.ibmcloud.v1.Metadata item) {
      this.builder = new io.fabric8.openshift.api.model.installer.ibmcloud.v1.MetadataBuilder(this, item);
    }
    io.fabric8.openshift.api.model.installer.ibmcloud.v1.MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withIbmcloud(builder.build());
    }
    
    public N endIbmcloud() {
      return and();
    }
    
  
  }
  public class NutanixNested<N> extends io.fabric8.openshift.api.model.installer.nutanix.v1.MetadataFluent<NutanixNested<N>> implements Nested<N>{
    NutanixNested(io.fabric8.openshift.api.model.installer.nutanix.v1.Metadata item) {
      this.builder = new io.fabric8.openshift.api.model.installer.nutanix.v1.MetadataBuilder(this, item);
    }
    io.fabric8.openshift.api.model.installer.nutanix.v1.MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withNutanix(builder.build());
    }
    
    public N endNutanix() {
      return and();
    }
    
  
  }
  public class OpenstackNested<N> extends io.fabric8.openshift.api.model.installer.openstack.v1.MetadataFluent<OpenstackNested<N>> implements Nested<N>{
    OpenstackNested(io.fabric8.openshift.api.model.installer.openstack.v1.Metadata item) {
      this.builder = new io.fabric8.openshift.api.model.installer.openstack.v1.MetadataBuilder(this, item);
    }
    io.fabric8.openshift.api.model.installer.openstack.v1.MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withOpenstack(builder.build());
    }
    
    public N endOpenstack() {
      return and();
    }
    
  
  }
  public class OvirtNested<N> extends io.fabric8.openshift.api.model.installer.ovirt.v1.MetadataFluent<OvirtNested<N>> implements Nested<N>{
    OvirtNested(io.fabric8.openshift.api.model.installer.ovirt.v1.Metadata item) {
      this.builder = new io.fabric8.openshift.api.model.installer.ovirt.v1.MetadataBuilder(this, item);
    }
    io.fabric8.openshift.api.model.installer.ovirt.v1.MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withOvirt(builder.build());
    }
    
    public N endOvirt() {
      return and();
    }
    
  
  }
  public class PowervsNested<N> extends io.fabric8.openshift.api.model.installer.powervs.v1.MetadataFluent<PowervsNested<N>> implements Nested<N>{
    PowervsNested(io.fabric8.openshift.api.model.installer.powervs.v1.Metadata item) {
      this.builder = new io.fabric8.openshift.api.model.installer.powervs.v1.MetadataBuilder(this, item);
    }
    io.fabric8.openshift.api.model.installer.powervs.v1.MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withPowervs(builder.build());
    }
    
    public N endPowervs() {
      return and();
    }
    
  
  }
  public class VsphereNested<N> extends io.fabric8.openshift.api.model.installer.vsphere.v1.MetadataFluent<VsphereNested<N>> implements Nested<N>{
    VsphereNested(io.fabric8.openshift.api.model.installer.vsphere.v1.Metadata item) {
      this.builder = new io.fabric8.openshift.api.model.installer.vsphere.v1.MetadataBuilder(this, item);
    }
    io.fabric8.openshift.api.model.installer.vsphere.v1.MetadataBuilder builder;
    
    public N and() {
      return (N) ClusterMetadataFluent.this.withVsphere(builder.build());
    }
    
    public N endVsphere() {
      return and();
    }
    
  
  }

}