package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsageFluent;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsage;
import io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsageBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterQuotaFluent<A extends ClusterQuotaFluent<A>> extends BaseFluent<A>{
  public ClusterQuotaFluent() {
  }
  
  public ClusterQuotaFluent(ClusterQuota instance) {
    this.copyInstance(instance);
  }
  private ArrayList<QuotaUsageBuilder> gcp = new ArrayList<QuotaUsageBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterQuota instance) {
    instance = (instance != null ? instance : new ClusterQuota());
    if (instance != null) {
          this.withGcp(instance.getGcp());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToGcp(int index,QuotaUsage item) {
    if (this.gcp == null) {this.gcp = new ArrayList<QuotaUsageBuilder>();}
    QuotaUsageBuilder builder = new QuotaUsageBuilder(item);
    if (index < 0 || index >= gcp.size()) {
        _visitables.get("gcp").add(builder);
        gcp.add(builder);
    } else {
        _visitables.get("gcp").add(builder);
        gcp.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToGcp(int index,QuotaUsage item) {
    if (this.gcp == null) {this.gcp = new ArrayList<QuotaUsageBuilder>();}
    QuotaUsageBuilder builder = new QuotaUsageBuilder(item);
    if (index < 0 || index >= gcp.size()) {
        _visitables.get("gcp").add(builder);
        gcp.add(builder);
    } else {
        _visitables.get("gcp").add(builder);
        gcp.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToGcp(io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsage... items) {
    if (this.gcp == null) {this.gcp = new ArrayList<QuotaUsageBuilder>();}
    for (QuotaUsage item : items) {QuotaUsageBuilder builder = new QuotaUsageBuilder(item);_visitables.get("gcp").add(builder);this.gcp.add(builder);} return (A)this;
  }
  
  public A addAllToGcp(Collection<QuotaUsage> items) {
    if (this.gcp == null) {this.gcp = new ArrayList<QuotaUsageBuilder>();}
    for (QuotaUsage item : items) {QuotaUsageBuilder builder = new QuotaUsageBuilder(item);_visitables.get("gcp").add(builder);this.gcp.add(builder);} return (A)this;
  }
  
  public A removeFromGcp(io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsage... items) {
    if (this.gcp == null) return (A)this;
    for (QuotaUsage item : items) {QuotaUsageBuilder builder = new QuotaUsageBuilder(item);_visitables.get("gcp").remove(builder); this.gcp.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGcp(Collection<QuotaUsage> items) {
    if (this.gcp == null) return (A)this;
    for (QuotaUsage item : items) {QuotaUsageBuilder builder = new QuotaUsageBuilder(item);_visitables.get("gcp").remove(builder); this.gcp.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGcp(Predicate<QuotaUsageBuilder> predicate) {
    if (gcp == null) return (A) this;
    final Iterator<QuotaUsageBuilder> each = gcp.iterator();
    final List visitables = _visitables.get("gcp");
    while (each.hasNext()) {
      QuotaUsageBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<QuotaUsage> buildGcp() {
    return this.gcp != null ? build(gcp) : null;
  }
  
  public QuotaUsage buildGcp(int index) {
    return this.gcp.get(index).build();
  }
  
  public QuotaUsage buildFirstGcp() {
    return this.gcp.get(0).build();
  }
  
  public QuotaUsage buildLastGcp() {
    return this.gcp.get(gcp.size() - 1).build();
  }
  
  public QuotaUsage buildMatchingGcp(Predicate<QuotaUsageBuilder> predicate) {
      for (QuotaUsageBuilder item : gcp) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGcp(Predicate<QuotaUsageBuilder> predicate) {
      for (QuotaUsageBuilder item : gcp) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGcp(List<QuotaUsage> gcp) {
    if (this.gcp != null) {
      this._visitables.get("gcp").clear();
    }
    if (gcp != null) {
        this.gcp = new ArrayList();
        for (QuotaUsage item : gcp) {
          this.addToGcp(item);
        }
    } else {
      this.gcp = null;
    }
    return (A) this;
  }
  
  public A withGcp(io.fabric8.openshift.api.model.installer.gcp.v1.QuotaUsage... gcp) {
    if (this.gcp != null) {
        this.gcp.clear();
        _visitables.remove("gcp");
    }
    if (gcp != null) {
      for (QuotaUsage item : gcp) {
        this.addToGcp(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null && !this.gcp.isEmpty();
  }
  
  public GcpNested<A> addNewGcp() {
    return new GcpNested(-1, null);
  }
  
  public GcpNested<A> addNewGcpLike(QuotaUsage item) {
    return new GcpNested(-1, item);
  }
  
  public GcpNested<A> setNewGcpLike(int index,QuotaUsage item) {
    return new GcpNested(index, item);
  }
  
  public GcpNested<A> editGcp(int index) {
    if (gcp.size() <= index) throw new RuntimeException("Can't edit gcp. Index exceeds size.");
    return setNewGcpLike(index, buildGcp(index));
  }
  
  public GcpNested<A> editFirstGcp() {
    if (gcp.size() == 0) throw new RuntimeException("Can't edit first gcp. The list is empty.");
    return setNewGcpLike(0, buildGcp(0));
  }
  
  public GcpNested<A> editLastGcp() {
    int index = gcp.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gcp. The list is empty.");
    return setNewGcpLike(index, buildGcp(index));
  }
  
  public GcpNested<A> editMatchingGcp(Predicate<QuotaUsageBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gcp.size();i++) { 
    if (predicate.test(gcp.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gcp. No match found.");
    return setNewGcpLike(index, buildGcp(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterQuotaFluent that = (ClusterQuotaFluent) o;
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(gcp,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (gcp != null && !gcp.isEmpty()) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class GcpNested<N> extends QuotaUsageFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(int index,QuotaUsage item) {
      this.index = index;
      this.builder = new QuotaUsageBuilder(this, item);
    }
    QuotaUsageBuilder builder;
    int index;
    
    public N and() {
      return (N) ClusterQuotaFluent.this.setToGcp(index,builder.build());
    }
    
    public N endGcp() {
      return and();
    }
    
  
  }

}