package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageDigestSourceBuilder extends ImageDigestSourceFluent<ImageDigestSourceBuilder> implements VisitableBuilder<ImageDigestSource,ImageDigestSourceBuilder>{
  public ImageDigestSourceBuilder() {
    this(new ImageDigestSource());
  }
  
  public ImageDigestSourceBuilder(ImageDigestSourceFluent<?> fluent) {
    this(fluent, new ImageDigestSource());
  }
  
  public ImageDigestSourceBuilder(ImageDigestSourceFluent<?> fluent,ImageDigestSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageDigestSourceBuilder(ImageDigestSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageDigestSourceFluent<?> fluent;
  
  public ImageDigestSource build() {
    ImageDigestSource buildable = new ImageDigestSource(fluent.getMirrors(),fluent.getSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}