package io.fabric8.openshift.api.model.installer.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  
  public MachinePoolFluent(MachinePool instance) {
    this.copyInstance(instance);
  }
  private String architecture;
  private FencingBuilder fencing;
  private String hyperthreading;
  private String name;
  private MachinePoolPlatformBuilder platform;
  private Long replicas;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());
    if (instance != null) {
          this.withArchitecture(instance.getArchitecture());
          this.withFencing(instance.getFencing());
          this.withHyperthreading(instance.getHyperthreading());
          this.withName(instance.getName());
          this.withPlatform(instance.getPlatform());
          this.withReplicas(instance.getReplicas());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getArchitecture() {
    return this.architecture;
  }
  
  public A withArchitecture(String architecture) {
    this.architecture = architecture;
    return (A) this;
  }
  
  public boolean hasArchitecture() {
    return this.architecture != null;
  }
  
  public Fencing buildFencing() {
    return this.fencing != null ? this.fencing.build() : null;
  }
  
  public A withFencing(Fencing fencing) {
    this._visitables.remove("fencing");
    if (fencing != null) {
        this.fencing = new FencingBuilder(fencing);
        this._visitables.get("fencing").add(this.fencing);
    } else {
        this.fencing = null;
        this._visitables.get("fencing").remove(this.fencing);
    }
    return (A) this;
  }
  
  public boolean hasFencing() {
    return this.fencing != null;
  }
  
  public FencingNested<A> withNewFencing() {
    return new FencingNested(null);
  }
  
  public FencingNested<A> withNewFencingLike(Fencing item) {
    return new FencingNested(item);
  }
  
  public FencingNested<A> editFencing() {
    return withNewFencingLike(java.util.Optional.ofNullable(buildFencing()).orElse(null));
  }
  
  public FencingNested<A> editOrNewFencing() {
    return withNewFencingLike(java.util.Optional.ofNullable(buildFencing()).orElse(new FencingBuilder().build()));
  }
  
  public FencingNested<A> editOrNewFencingLike(Fencing item) {
    return withNewFencingLike(java.util.Optional.ofNullable(buildFencing()).orElse(item));
  }
  
  public String getHyperthreading() {
    return this.hyperthreading;
  }
  
  public A withHyperthreading(String hyperthreading) {
    this.hyperthreading = hyperthreading;
    return (A) this;
  }
  
  public boolean hasHyperthreading() {
    return this.hyperthreading != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public MachinePoolPlatform buildPlatform() {
    return this.platform != null ? this.platform.build() : null;
  }
  
  public A withPlatform(MachinePoolPlatform platform) {
    this._visitables.remove("platform");
    if (platform != null) {
        this.platform = new MachinePoolPlatformBuilder(platform);
        this._visitables.get("platform").add(this.platform);
    } else {
        this.platform = null;
        this._visitables.get("platform").remove(this.platform);
    }
    return (A) this;
  }
  
  public boolean hasPlatform() {
    return this.platform != null;
  }
  
  public PlatformNested<A> withNewPlatform() {
    return new PlatformNested(null);
  }
  
  public PlatformNested<A> withNewPlatformLike(MachinePoolPlatform item) {
    return new PlatformNested(item);
  }
  
  public PlatformNested<A> editPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(null));
  }
  
  public PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(new MachinePoolPlatformBuilder().build()));
  }
  
  public PlatformNested<A> editOrNewPlatformLike(MachinePoolPlatform item) {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(item));
  }
  
  public Long getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Long replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(architecture, that.architecture)) return false;
    if (!java.util.Objects.equals(fencing, that.fencing)) return false;
    if (!java.util.Objects.equals(hyperthreading, that.hyperthreading)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(platform, that.platform)) return false;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(architecture,  fencing,  hyperthreading,  name,  platform,  replicas,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (architecture != null) { sb.append("architecture:"); sb.append(architecture + ","); }
    if (fencing != null) { sb.append("fencing:"); sb.append(fencing + ","); }
    if (hyperthreading != null) { sb.append("hyperthreading:"); sb.append(hyperthreading + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FencingNested<N> extends FencingFluent<FencingNested<N>> implements Nested<N>{
    FencingNested(Fencing item) {
      this.builder = new FencingBuilder(this, item);
    }
    FencingBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withFencing(builder.build());
    }
    
    public N endFencing() {
      return and();
    }
    
  
  }
  public class PlatformNested<N> extends MachinePoolPlatformFluent<PlatformNested<N>> implements Nested<N>{
    PlatformNested(MachinePoolPlatform item) {
      this.builder = new MachinePoolPlatformBuilder(this, item);
    }
    MachinePoolPlatformBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withPlatform(builder.build());
    }
    
    public N endPlatform() {
      return and();
    }
    
  
  }

}