package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkingFluent<A extends NetworkingFluent<A>> extends BaseFluent<A>{
  public NetworkingFluent() {
  }
  
  public NetworkingFluent(Networking instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
  private Long clusterNetworkMTU;
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetworkList = new ArrayList<ClusterNetworkEntryBuilder>();
  private String machineCIDR;
  private ArrayList<MachineNetworkEntryBuilder> machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();
  private String networkType;
  private OVNKubernetesConfigBuilder ovnKubernetesConfig;
  private String serviceCIDR;
  private List<String> serviceNetwork = new ArrayList<String>();
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Networking instance) {
    instance = (instance != null ? instance : new Networking());
    if (instance != null) {
          this.withClusterNetwork(instance.getClusterNetwork());
          this.withClusterNetworkMTU(instance.getClusterNetworkMTU());
          this.withMachineCIDR(instance.getMachineCIDR());
          this.withMachineNetwork(instance.getMachineNetwork());
          this.withNetworkType(instance.getNetworkType());
          this.withOvnKubernetesConfig(instance.getOvnKubernetesConfig());
          this.withServiceCIDR(instance.getServiceCIDR());
          this.withServiceNetwork(instance.getServiceNetwork());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetwork.size()) {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.add(builder);
    } else {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetwork.size()) {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.add(builder);
    } else {
        _visitables.get("clusterNetwork").add(builder);
        clusterNetwork.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder); this.clusterNetwork.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder); this.clusterNetwork.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterNetworkEntry> buildClusterNetwork() {
    return this.clusterNetwork != null ? build(clusterNetwork) : null;
  }
  
  public ClusterNetworkEntry buildClusterNetwork(int index) {
    return this.clusterNetwork.get(index).build();
  }
  
  public ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  
  public ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
      for (ClusterNetworkEntryBuilder item : clusterNetwork) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
      for (ClusterNetworkEntryBuilder item : clusterNetwork) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) {
      this._visitables.get("clusterNetwork").clear();
    }
    if (clusterNetwork != null) {
        this.clusterNetwork = new ArrayList();
        for (ClusterNetworkEntry item : clusterNetwork) {
          this.addToClusterNetwork(item);
        }
    } else {
      this.clusterNetwork = null;
    }
    return (A) this;
  }
  
  public A withClusterNetwork(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {
        this.clusterNetwork.clear();
        _visitables.remove("clusterNetwork");
    }
    if (clusterNetwork != null) {
      for (ClusterNetworkEntry item : clusterNetwork) {
        this.addToClusterNetwork(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusterNetwork() {
    return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
  }
  
  public A addNewClusterNetwork(String cidr,Integer hostPrefix,Integer hostSubnetLength) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
  }
  
  public ClusterNetworkNested<A> addNewClusterNetwork() {
    return new ClusterNetworkNested(-1, null);
  }
  
  public ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
    return new ClusterNetworkNested(-1, item);
  }
  
  public ClusterNetworkNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item) {
    return new ClusterNetworkNested(index, item);
  }
  
  public ClusterNetworkNested<A> editClusterNetwork(int index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  public ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  
  public ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  public ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  public Long getClusterNetworkMTU() {
    return this.clusterNetworkMTU;
  }
  
  public A withClusterNetworkMTU(Long clusterNetworkMTU) {
    this.clusterNetworkMTU = clusterNetworkMTU;
    return (A) this;
  }
  
  public boolean hasClusterNetworkMTU() {
    return this.clusterNetworkMTU != null;
  }
  
  public A addToClusterNetworkList(int index,ClusterNetworkEntry item) {
    if (this.clusterNetworkList == null) {this.clusterNetworkList = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetworkList.size()) {
        _visitables.get("clusterNetworkList").add(builder);
        clusterNetworkList.add(builder);
    } else {
        _visitables.get("clusterNetworkList").add(builder);
        clusterNetworkList.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToClusterNetworkList(int index,ClusterNetworkEntry item) {
    if (this.clusterNetworkList == null) {this.clusterNetworkList = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetworkList.size()) {
        _visitables.get("clusterNetworkList").add(builder);
        clusterNetworkList.add(builder);
    } else {
        _visitables.get("clusterNetworkList").add(builder);
        clusterNetworkList.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToClusterNetworkList(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetworkList == null) {this.clusterNetworkList = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworkList").add(builder);this.clusterNetworkList.add(builder);} return (A)this;
  }
  
  public A addAllToClusterNetworkList(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetworkList == null) {this.clusterNetworkList = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworkList").add(builder);this.clusterNetworkList.add(builder);} return (A)this;
  }
  
  public A removeFromClusterNetworkList(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetworkList == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworkList").remove(builder); this.clusterNetworkList.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusterNetworkList(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetworkList == null) return (A)this;
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworkList").remove(builder); this.clusterNetworkList.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusterNetworkList(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetworkList == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = clusterNetworkList.iterator();
    final List visitables = _visitables.get("clusterNetworkList");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClusterNetworkEntry> buildClusterNetworkList() {
    return this.clusterNetworkList != null ? build(clusterNetworkList) : null;
  }
  
  public ClusterNetworkEntry buildClusterNetworkList(int index) {
    return this.clusterNetworkList.get(index).build();
  }
  
  public ClusterNetworkEntry buildFirstClusterNetworkList() {
    return this.clusterNetworkList.get(0).build();
  }
  
  public ClusterNetworkEntry buildLastClusterNetworkList() {
    return this.clusterNetworkList.get(clusterNetworkList.size() - 1).build();
  }
  
  public ClusterNetworkEntry buildMatchingClusterNetworkList(Predicate<ClusterNetworkEntryBuilder> predicate) {
      for (ClusterNetworkEntryBuilder item : clusterNetworkList) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingClusterNetworkList(Predicate<ClusterNetworkEntryBuilder> predicate) {
      for (ClusterNetworkEntryBuilder item : clusterNetworkList) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusterNetworkList(List<ClusterNetworkEntry> clusterNetworkList) {
    if (this.clusterNetworkList != null) {
      this._visitables.get("clusterNetworkList").clear();
    }
    if (clusterNetworkList != null) {
        this.clusterNetworkList = new ArrayList();
        for (ClusterNetworkEntry item : clusterNetworkList) {
          this.addToClusterNetworkList(item);
        }
    } else {
      this.clusterNetworkList = null;
    }
    return (A) this;
  }
  
  public A withClusterNetworkList(io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry... clusterNetworkList) {
    if (this.clusterNetworkList != null) {
        this.clusterNetworkList.clear();
        _visitables.remove("clusterNetworkList");
    }
    if (clusterNetworkList != null) {
      for (ClusterNetworkEntry item : clusterNetworkList) {
        this.addToClusterNetworkList(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusterNetworkList() {
    return this.clusterNetworkList != null && !this.clusterNetworkList.isEmpty();
  }
  
  public A addNewClusterNetworkList(String cidr,Integer hostPrefix,Integer hostSubnetLength) {
    return (A)addToClusterNetworkList(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
  }
  
  public ClusterNetworkListNested<A> addNewClusterNetworkList() {
    return new ClusterNetworkListNested(-1, null);
  }
  
  public ClusterNetworkListNested<A> addNewClusterNetworkListLike(ClusterNetworkEntry item) {
    return new ClusterNetworkListNested(-1, item);
  }
  
  public ClusterNetworkListNested<A> setNewClusterNetworkListLike(int index,ClusterNetworkEntry item) {
    return new ClusterNetworkListNested(index, item);
  }
  
  public ClusterNetworkListNested<A> editClusterNetworkList(int index) {
    if (clusterNetworkList.size() <= index) throw new RuntimeException("Can't edit clusterNetworkList. Index exceeds size.");
    return setNewClusterNetworkListLike(index, buildClusterNetworkList(index));
  }
  
  public ClusterNetworkListNested<A> editFirstClusterNetworkList() {
    if (clusterNetworkList.size() == 0) throw new RuntimeException("Can't edit first clusterNetworkList. The list is empty.");
    return setNewClusterNetworkListLike(0, buildClusterNetworkList(0));
  }
  
  public ClusterNetworkListNested<A> editLastClusterNetworkList() {
    int index = clusterNetworkList.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetworkList. The list is empty.");
    return setNewClusterNetworkListLike(index, buildClusterNetworkList(index));
  }
  
  public ClusterNetworkListNested<A> editMatchingClusterNetworkList(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetworkList.size();i++) { 
    if (predicate.test(clusterNetworkList.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetworkList. No match found.");
    return setNewClusterNetworkListLike(index, buildClusterNetworkList(index));
  }
  
  public String getMachineCIDR() {
    return this.machineCIDR;
  }
  
  public A withMachineCIDR(String machineCIDR) {
    this.machineCIDR = machineCIDR;
    return (A) this;
  }
  
  public boolean hasMachineCIDR() {
    return this.machineCIDR != null;
  }
  
  public A addToMachineNetwork(int index,MachineNetworkEntry item) {
    if (this.machineNetwork == null) {this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();}
    MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
    if (index < 0 || index >= machineNetwork.size()) {
        _visitables.get("machineNetwork").add(builder);
        machineNetwork.add(builder);
    } else {
        _visitables.get("machineNetwork").add(builder);
        machineNetwork.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToMachineNetwork(int index,MachineNetworkEntry item) {
    if (this.machineNetwork == null) {this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();}
    MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
    if (index < 0 || index >= machineNetwork.size()) {
        _visitables.get("machineNetwork").add(builder);
        machineNetwork.add(builder);
    } else {
        _visitables.get("machineNetwork").add(builder);
        machineNetwork.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... items) {
    if (this.machineNetwork == null) {this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();}
    for (MachineNetworkEntry item : items) {MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").add(builder);this.machineNetwork.add(builder);} return (A)this;
  }
  
  public A addAllToMachineNetwork(Collection<MachineNetworkEntry> items) {
    if (this.machineNetwork == null) {this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();}
    for (MachineNetworkEntry item : items) {MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").add(builder);this.machineNetwork.add(builder);} return (A)this;
  }
  
  public A removeFromMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... items) {
    if (this.machineNetwork == null) return (A)this;
    for (MachineNetworkEntry item : items) {MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").remove(builder); this.machineNetwork.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMachineNetwork(Collection<MachineNetworkEntry> items) {
    if (this.machineNetwork == null) return (A)this;
    for (MachineNetworkEntry item : items) {MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);_visitables.get("machineNetwork").remove(builder); this.machineNetwork.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
    if (machineNetwork == null) return (A) this;
    final Iterator<MachineNetworkEntryBuilder> each = machineNetwork.iterator();
    final List visitables = _visitables.get("machineNetwork");
    while (each.hasNext()) {
      MachineNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MachineNetworkEntry> buildMachineNetwork() {
    return this.machineNetwork != null ? build(machineNetwork) : null;
  }
  
  public MachineNetworkEntry buildMachineNetwork(int index) {
    return this.machineNetwork.get(index).build();
  }
  
  public MachineNetworkEntry buildFirstMachineNetwork() {
    return this.machineNetwork.get(0).build();
  }
  
  public MachineNetworkEntry buildLastMachineNetwork() {
    return this.machineNetwork.get(machineNetwork.size() - 1).build();
  }
  
  public MachineNetworkEntry buildMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
      for (MachineNetworkEntryBuilder item : machineNetwork) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
      for (MachineNetworkEntryBuilder item : machineNetwork) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMachineNetwork(List<MachineNetworkEntry> machineNetwork) {
    if (this.machineNetwork != null) {
      this._visitables.get("machineNetwork").clear();
    }
    if (machineNetwork != null) {
        this.machineNetwork = new ArrayList();
        for (MachineNetworkEntry item : machineNetwork) {
          this.addToMachineNetwork(item);
        }
    } else {
      this.machineNetwork = null;
    }
    return (A) this;
  }
  
  public A withMachineNetwork(io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry... machineNetwork) {
    if (this.machineNetwork != null) {
        this.machineNetwork.clear();
        _visitables.remove("machineNetwork");
    }
    if (machineNetwork != null) {
      for (MachineNetworkEntry item : machineNetwork) {
        this.addToMachineNetwork(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMachineNetwork() {
    return this.machineNetwork != null && !this.machineNetwork.isEmpty();
  }
  
  public A addNewMachineNetwork(String cidr) {
    return (A)addToMachineNetwork(new MachineNetworkEntry(cidr));
  }
  
  public MachineNetworkNested<A> addNewMachineNetwork() {
    return new MachineNetworkNested(-1, null);
  }
  
  public MachineNetworkNested<A> addNewMachineNetworkLike(MachineNetworkEntry item) {
    return new MachineNetworkNested(-1, item);
  }
  
  public MachineNetworkNested<A> setNewMachineNetworkLike(int index,MachineNetworkEntry item) {
    return new MachineNetworkNested(index, item);
  }
  
  public MachineNetworkNested<A> editMachineNetwork(int index) {
    if (machineNetwork.size() <= index) throw new RuntimeException("Can't edit machineNetwork. Index exceeds size.");
    return setNewMachineNetworkLike(index, buildMachineNetwork(index));
  }
  
  public MachineNetworkNested<A> editFirstMachineNetwork() {
    if (machineNetwork.size() == 0) throw new RuntimeException("Can't edit first machineNetwork. The list is empty.");
    return setNewMachineNetworkLike(0, buildMachineNetwork(0));
  }
  
  public MachineNetworkNested<A> editLastMachineNetwork() {
    int index = machineNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last machineNetwork. The list is empty.");
    return setNewMachineNetworkLike(index, buildMachineNetwork(index));
  }
  
  public MachineNetworkNested<A> editMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<machineNetwork.size();i++) { 
    if (predicate.test(machineNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching machineNetwork. No match found.");
    return setNewMachineNetworkLike(index, buildMachineNetwork(index));
  }
  
  public String getNetworkType() {
    return this.networkType;
  }
  
  public A withNetworkType(String networkType) {
    this.networkType = networkType;
    return (A) this;
  }
  
  public boolean hasNetworkType() {
    return this.networkType != null;
  }
  
  public OVNKubernetesConfig buildOvnKubernetesConfig() {
    return this.ovnKubernetesConfig != null ? this.ovnKubernetesConfig.build() : null;
  }
  
  public A withOvnKubernetesConfig(OVNKubernetesConfig ovnKubernetesConfig) {
    this._visitables.remove("ovnKubernetesConfig");
    if (ovnKubernetesConfig != null) {
        this.ovnKubernetesConfig = new OVNKubernetesConfigBuilder(ovnKubernetesConfig);
        this._visitables.get("ovnKubernetesConfig").add(this.ovnKubernetesConfig);
    } else {
        this.ovnKubernetesConfig = null;
        this._visitables.get("ovnKubernetesConfig").remove(this.ovnKubernetesConfig);
    }
    return (A) this;
  }
  
  public boolean hasOvnKubernetesConfig() {
    return this.ovnKubernetesConfig != null;
  }
  
  public OvnKubernetesConfigNested<A> withNewOvnKubernetesConfig() {
    return new OvnKubernetesConfigNested(null);
  }
  
  public OvnKubernetesConfigNested<A> withNewOvnKubernetesConfigLike(OVNKubernetesConfig item) {
    return new OvnKubernetesConfigNested(item);
  }
  
  public OvnKubernetesConfigNested<A> editOvnKubernetesConfig() {
    return withNewOvnKubernetesConfigLike(java.util.Optional.ofNullable(buildOvnKubernetesConfig()).orElse(null));
  }
  
  public OvnKubernetesConfigNested<A> editOrNewOvnKubernetesConfig() {
    return withNewOvnKubernetesConfigLike(java.util.Optional.ofNullable(buildOvnKubernetesConfig()).orElse(new OVNKubernetesConfigBuilder().build()));
  }
  
  public OvnKubernetesConfigNested<A> editOrNewOvnKubernetesConfigLike(OVNKubernetesConfig item) {
    return withNewOvnKubernetesConfigLike(java.util.Optional.ofNullable(buildOvnKubernetesConfig()).orElse(item));
  }
  
  public String getServiceCIDR() {
    return this.serviceCIDR;
  }
  
  public A withServiceCIDR(String serviceCIDR) {
    this.serviceCIDR = serviceCIDR;
    return (A) this;
  }
  
  public boolean hasServiceCIDR() {
    return this.serviceCIDR != null;
  }
  
  public A addToServiceNetwork(int index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  
  public A setToServiceNetwork(int index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  
  public A addAllToServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  
  public A removeFromServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) return (A)this;
    for (String item : items) { this.serviceNetwork.remove(item);} return (A)this;
  }
  
  public A removeAllFromServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) return (A)this;
    for (String item : items) { this.serviceNetwork.remove(item);} return (A)this;
  }
  
  public List<String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  
  public String getServiceNetwork(int index) {
    return this.serviceNetwork.get(index);
  }
  
  public String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  
  public String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  
  public String getMatchingServiceNetwork(Predicate<String> predicate) {
      for (String item : serviceNetwork) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
      for (String item : serviceNetwork) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServiceNetwork(List<String> serviceNetwork) {
    if (serviceNetwork != null) {
        this.serviceNetwork = new ArrayList();
        for (String item : serviceNetwork) {
          this.addToServiceNetwork(item);
        }
    } else {
      this.serviceNetwork = null;
    }
    return (A) this;
  }
  
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {
        this.serviceNetwork.clear();
        _visitables.remove("serviceNetwork");
    }
    if (serviceNetwork != null) {
      for (String item : serviceNetwork) {
        this.addToServiceNetwork(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasServiceNetwork() {
    return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkingFluent that = (NetworkingFluent) o;
    if (!java.util.Objects.equals(clusterNetwork, that.clusterNetwork)) return false;
    if (!java.util.Objects.equals(clusterNetworkMTU, that.clusterNetworkMTU)) return false;
    if (!java.util.Objects.equals(clusterNetworkList, that.clusterNetworkList)) return false;
    if (!java.util.Objects.equals(machineCIDR, that.machineCIDR)) return false;
    if (!java.util.Objects.equals(machineNetwork, that.machineNetwork)) return false;
    if (!java.util.Objects.equals(networkType, that.networkType)) return false;
    if (!java.util.Objects.equals(ovnKubernetesConfig, that.ovnKubernetesConfig)) return false;
    if (!java.util.Objects.equals(serviceCIDR, that.serviceCIDR)) return false;
    if (!java.util.Objects.equals(serviceNetwork, that.serviceNetwork)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterNetwork,  clusterNetworkMTU,  clusterNetworkList,  machineCIDR,  machineNetwork,  networkType,  ovnKubernetesConfig,  serviceCIDR,  serviceNetwork,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterNetwork != null && !clusterNetwork.isEmpty()) { sb.append("clusterNetwork:"); sb.append(clusterNetwork + ","); }
    if (clusterNetworkMTU != null) { sb.append("clusterNetworkMTU:"); sb.append(clusterNetworkMTU + ","); }
    if (clusterNetworkList != null && !clusterNetworkList.isEmpty()) { sb.append("clusterNetworkList:"); sb.append(clusterNetworkList + ","); }
    if (machineCIDR != null) { sb.append("machineCIDR:"); sb.append(machineCIDR + ","); }
    if (machineNetwork != null && !machineNetwork.isEmpty()) { sb.append("machineNetwork:"); sb.append(machineNetwork + ","); }
    if (networkType != null) { sb.append("networkType:"); sb.append(networkType + ","); }
    if (ovnKubernetesConfig != null) { sb.append("ovnKubernetesConfig:"); sb.append(ovnKubernetesConfig + ","); }
    if (serviceCIDR != null) { sb.append("serviceCIDR:"); sb.append(serviceCIDR + ","); }
    if (serviceNetwork != null && !serviceNetwork.isEmpty()) { sb.append("serviceNetwork:"); sb.append(serviceNetwork + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterNetworkNested<N> extends ClusterNetworkEntryFluent<ClusterNetworkNested<N>> implements Nested<N>{
    ClusterNetworkNested(int index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkingFluent.this.setToClusterNetwork(index,builder.build());
    }
    
    public N endClusterNetwork() {
      return and();
    }
    
  
  }
  public class ClusterNetworkListNested<N> extends ClusterNetworkEntryFluent<ClusterNetworkListNested<N>> implements Nested<N>{
    ClusterNetworkListNested(int index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkingFluent.this.setToClusterNetworkList(index,builder.build());
    }
    
    public N endClusterNetworkList() {
      return and();
    }
    
  
  }
  public class MachineNetworkNested<N> extends MachineNetworkEntryFluent<MachineNetworkNested<N>> implements Nested<N>{
    MachineNetworkNested(int index,MachineNetworkEntry item) {
      this.index = index;
      this.builder = new MachineNetworkEntryBuilder(this, item);
    }
    MachineNetworkEntryBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkingFluent.this.setToMachineNetwork(index,builder.build());
    }
    
    public N endMachineNetwork() {
      return and();
    }
    
  
  }
  public class OvnKubernetesConfigNested<N> extends OVNKubernetesConfigFluent<OvnKubernetesConfigNested<N>> implements Nested<N>{
    OvnKubernetesConfigNested(OVNKubernetesConfig item) {
      this.builder = new OVNKubernetesConfigBuilder(this, item);
    }
    OVNKubernetesConfigBuilder builder;
    
    public N and() {
      return (N) NetworkingFluent.this.withOvnKubernetesConfig(builder.build());
    }
    
    public N endOvnKubernetesConfig() {
      return and();
    }
    
  
  }

}