package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VCentersBuilder extends VCentersFluent<VCentersBuilder> implements VisitableBuilder<VCenters,VCentersBuilder>{
  public VCentersBuilder() {
    this(new VCenters());
  }
  
  public VCentersBuilder(VCentersFluent<?> fluent) {
    this(fluent, new VCenters());
  }
  
  public VCentersBuilder(VCentersFluent<?> fluent,VCenters instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VCentersBuilder(VCenters instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VCentersFluent<?> fluent;
  
  public VCenters build() {
    VCenters buildable = new VCenters(fluent.getPassword(),fluent.getUsername(),fluent.getVCenter());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}