/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.gcp.v1.DNS;
import io.fabric8.openshift.api.model.installer.gcp.v1.DNSBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.DNSFluent;
import io.fabric8.openshift.api.model.installer.gcp.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.gcp.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.gcp.v1.PSCEndpoint;
import io.fabric8.openshift.api.model.installer.gcp.v1.PSCEndpointBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.PSCEndpointFluent;
import io.fabric8.openshift.api.model.installer.gcp.v1.Platform;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserLabel;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserLabelBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserLabelFluent;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserTag;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserTagBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserTagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String computeSubnet;
    private String controlPlaneSubnet;
    private MachinePoolBuilder defaultMachinePlatform;
    private DNSBuilder dns;
    private PSCEndpointBuilder endpoint;
    private String firewallRulesManagement;
    private String network;
    private String networkProjectID;
    private String projectID;
    private String region;
    private ArrayList<UserLabelBuilder> userLabels = new ArrayList();
    private String userProvisionedDNS;
    private ArrayList<UserTagBuilder> userTags = new ArrayList();

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    public A addAllToUserLabels(Collection<UserLabel> items) {
        if (this.userLabels == null) {
            this.userLabels = new ArrayList();
        }
        for (UserLabel item : items) {
            UserLabelBuilder builder = new UserLabelBuilder(item);
            this._visitables.get((Object)"userLabels").add(builder);
            this.userLabels.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToUserTags(Collection<UserTag> items) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get((Object)"userTags").add(builder);
            this.userTags.add(builder);
        }
        return (A)((Object)this);
    }

    public UserLabelsNested<A> addNewUserLabel() {
        return new UserLabelsNested(-1, null);
    }

    public A addNewUserLabel(String key, String value) {
        return this.addToUserLabels(new UserLabel(key, value));
    }

    public UserLabelsNested<A> addNewUserLabelLike(UserLabel item) {
        return new UserLabelsNested(-1, item);
    }

    public UserTagsNested<A> addNewUserTag() {
        return new UserTagsNested(-1, null);
    }

    public A addNewUserTag(String key, String parentID, String value) {
        return this.addToUserTags(new UserTag(key, parentID, value));
    }

    public UserTagsNested<A> addNewUserTagLike(UserTag item) {
        return new UserTagsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToUserLabels(UserLabel ... items) {
        if (this.userLabels == null) {
            this.userLabels = new ArrayList();
        }
        for (UserLabel item : items) {
            UserLabelBuilder builder = new UserLabelBuilder(item);
            this._visitables.get((Object)"userLabels").add(builder);
            this.userLabels.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToUserLabels(int index, UserLabel item) {
        if (this.userLabels == null) {
            this.userLabels = new ArrayList();
        }
        UserLabelBuilder builder = new UserLabelBuilder(item);
        if (index < 0 || index >= this.userLabels.size()) {
            this._visitables.get((Object)"userLabels").add(builder);
            this.userLabels.add(builder);
        } else {
            this._visitables.get((Object)"userLabels").add(builder);
            this.userLabels.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToUserTags(UserTag ... items) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get((Object)"userTags").add(builder);
            this.userTags.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToUserTags(int index, UserTag item) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        UserTagBuilder builder = new UserTagBuilder(item);
        if (index < 0 || index >= this.userTags.size()) {
            this._visitables.get((Object)"userTags").add(builder);
            this.userTags.add(builder);
        } else {
            this._visitables.get((Object)"userTags").add(builder);
            this.userTags.add(index, builder);
        }
        return (A)((Object)this);
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public DNS buildDns() {
        return this.dns != null ? this.dns.build() : null;
    }

    public PSCEndpoint buildEndpoint() {
        return this.endpoint != null ? this.endpoint.build() : null;
    }

    public UserLabel buildFirstUserLabel() {
        return this.userLabels.get(0).build();
    }

    public UserTag buildFirstUserTag() {
        return this.userTags.get(0).build();
    }

    public UserLabel buildLastUserLabel() {
        return this.userLabels.get(this.userLabels.size() - 1).build();
    }

    public UserTag buildLastUserTag() {
        return this.userTags.get(this.userTags.size() - 1).build();
    }

    public UserLabel buildMatchingUserLabel(Predicate<UserLabelBuilder> predicate) {
        for (UserLabelBuilder item : this.userLabels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public UserTag buildMatchingUserTag(Predicate<UserTagBuilder> predicate) {
        for (UserTagBuilder item : this.userTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public UserLabel buildUserLabel(int index) {
        return this.userLabels.get(index).build();
    }

    public List<UserLabel> buildUserLabels() {
        return this.userLabels != null ? PlatformFluent.build(this.userLabels) : null;
    }

    public UserTag buildUserTag(int index) {
        return this.userTags.get(index).build();
    }

    public List<UserTag> buildUserTags() {
        return this.userTags != null ? PlatformFluent.build(this.userTags) : null;
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withComputeSubnet(instance.getComputeSubnet());
            this.withControlPlaneSubnet(instance.getControlPlaneSubnet());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withDns(instance.getDns());
            this.withEndpoint(instance.getEndpoint());
            this.withFirewallRulesManagement(instance.getFirewallRulesManagement());
            this.withNetwork(instance.getNetwork());
            this.withNetworkProjectID(instance.getNetworkProjectID());
            this.withProjectID(instance.getProjectID());
            this.withRegion(instance.getRegion());
            this.withUserLabels(instance.getUserLabels());
            this.withUserProvisionedDNS(instance.getUserProvisionedDNS());
            this.withUserTags(instance.getUserTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DnsNested<A> editDns() {
        return this.withNewDnsLike(Optional.ofNullable(this.buildDns()).orElse(null));
    }

    public EndpointNested<A> editEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(null));
    }

    public UserLabelsNested<A> editFirstUserLabel() {
        if (this.userLabels.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "userLabels"));
        }
        return this.setNewUserLabelLike(0, this.buildUserLabel(0));
    }

    public UserTagsNested<A> editFirstUserTag() {
        if (this.userTags.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "userTags"));
        }
        return this.setNewUserTagLike(0, this.buildUserTag(0));
    }

    public UserLabelsNested<A> editLastUserLabel() {
        int index = this.userLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "userLabels"));
        }
        return this.setNewUserLabelLike(index, this.buildUserLabel(index));
    }

    public UserTagsNested<A> editLastUserTag() {
        int index = this.userTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "userTags"));
        }
        return this.setNewUserTagLike(index, this.buildUserTag(index));
    }

    public UserLabelsNested<A> editMatchingUserLabel(Predicate<UserLabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.userLabels.size(); ++i) {
            if (!predicate.test(this.userLabels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "userLabels"));
        }
        return this.setNewUserLabelLike(index, this.buildUserLabel(index));
    }

    public UserTagsNested<A> editMatchingUserTag(Predicate<UserTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.userTags.size(); ++i) {
            if (!predicate.test(this.userTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "userTags"));
        }
        return this.setNewUserTagLike(index, this.buildUserTag(index));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public DnsNested<A> editOrNewDns() {
        return this.withNewDnsLike(Optional.ofNullable(this.buildDns()).orElse(new DNSBuilder().build()));
    }

    public DnsNested<A> editOrNewDnsLike(DNS item) {
        return this.withNewDnsLike(Optional.ofNullable(this.buildDns()).orElse(item));
    }

    public EndpointNested<A> editOrNewEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(new PSCEndpointBuilder().build()));
    }

    public EndpointNested<A> editOrNewEndpointLike(PSCEndpoint item) {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(item));
    }

    public UserLabelsNested<A> editUserLabel(int index) {
        if (this.userLabels.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "userLabels"));
        }
        return this.setNewUserLabelLike(index, this.buildUserLabel(index));
    }

    public UserTagsNested<A> editUserTag(int index) {
        if (this.userTags.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "userTags"));
        }
        return this.setNewUserTagLike(index, this.buildUserTag(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)((Object)o);
        if (!Objects.equals(this.computeSubnet, that.computeSubnet)) {
            return false;
        }
        if (!Objects.equals(this.controlPlaneSubnet, that.controlPlaneSubnet)) {
            return false;
        }
        if (!Objects.equals((Object)this.defaultMachinePlatform, (Object)that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals((Object)this.dns, (Object)that.dns)) {
            return false;
        }
        if (!Objects.equals((Object)this.endpoint, (Object)that.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.firewallRulesManagement, that.firewallRulesManagement)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.networkProjectID, that.networkProjectID)) {
            return false;
        }
        if (!Objects.equals(this.projectID, that.projectID)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.userLabels, that.userLabels)) {
            return false;
        }
        if (!Objects.equals(this.userProvisionedDNS, that.userProvisionedDNS)) {
            return false;
        }
        if (!Objects.equals(this.userTags, that.userTags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getComputeSubnet() {
        return this.computeSubnet;
    }

    public String getControlPlaneSubnet() {
        return this.controlPlaneSubnet;
    }

    public String getFirewallRulesManagement() {
        return this.firewallRulesManagement;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getNetworkProjectID() {
        return this.networkProjectID;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public String getRegion() {
        return this.region;
    }

    public String getUserProvisionedDNS() {
        return this.userProvisionedDNS;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasComputeSubnet() {
        return this.computeSubnet != null;
    }

    public boolean hasControlPlaneSubnet() {
        return this.controlPlaneSubnet != null;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public boolean hasDns() {
        return this.dns != null;
    }

    public boolean hasEndpoint() {
        return this.endpoint != null;
    }

    public boolean hasFirewallRulesManagement() {
        return this.firewallRulesManagement != null;
    }

    public boolean hasMatchingUserLabel(Predicate<UserLabelBuilder> predicate) {
        for (UserLabelBuilder item : this.userLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingUserTag(Predicate<UserTagBuilder> predicate) {
        for (UserTagBuilder item : this.userTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public boolean hasNetworkProjectID() {
        return this.networkProjectID != null;
    }

    public boolean hasProjectID() {
        return this.projectID != null;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public boolean hasUserLabels() {
        return this.userLabels != null && !this.userLabels.isEmpty();
    }

    public boolean hasUserProvisionedDNS() {
        return this.userProvisionedDNS != null;
    }

    public boolean hasUserTags() {
        return this.userTags != null && !this.userTags.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.computeSubnet, this.controlPlaneSubnet, this.defaultMachinePlatform, this.dns, this.endpoint, this.firewallRulesManagement, this.network, this.networkProjectID, this.projectID, this.region, this.userLabels, this.userProvisionedDNS, this.userTags, this.additionalProperties});
    }

    public A removeAllFromUserLabels(Collection<UserLabel> items) {
        if (this.userLabels == null) {
            return (A)((Object)this);
        }
        for (UserLabel item : items) {
            UserLabelBuilder builder = new UserLabelBuilder(item);
            this._visitables.get((Object)"userLabels").remove((Object)builder);
            this.userLabels.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUserTags(Collection<UserTag> items) {
        if (this.userTags == null) {
            return (A)((Object)this);
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get((Object)"userTags").remove((Object)builder);
            this.userTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromUserLabels(UserLabel ... items) {
        if (this.userLabels == null) {
            return (A)((Object)this);
        }
        for (UserLabel item : items) {
            UserLabelBuilder builder = new UserLabelBuilder(item);
            this._visitables.get((Object)"userLabels").remove((Object)builder);
            this.userLabels.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromUserTags(UserTag ... items) {
        if (this.userTags == null) {
            return (A)((Object)this);
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get((Object)"userTags").remove((Object)builder);
            this.userTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromUserLabels(Predicate<UserLabelBuilder> predicate) {
        if (this.userLabels == null) {
            return (A)((Object)this);
        }
        Iterator<UserLabelBuilder> each = this.userLabels.iterator();
        List visitables = this._visitables.get((Object)"userLabels");
        while (each.hasNext()) {
            UserLabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromUserTags(Predicate<UserTagBuilder> predicate) {
        if (this.userTags == null) {
            return (A)((Object)this);
        }
        Iterator<UserTagBuilder> each = this.userTags.iterator();
        List visitables = this._visitables.get((Object)"userTags");
        while (each.hasNext()) {
            UserTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public UserLabelsNested<A> setNewUserLabelLike(int index, UserLabel item) {
        return new UserLabelsNested(index, item);
    }

    public UserTagsNested<A> setNewUserTagLike(int index, UserTag item) {
        return new UserTagsNested(index, item);
    }

    public A setToUserLabels(int index, UserLabel item) {
        if (this.userLabels == null) {
            this.userLabels = new ArrayList();
        }
        UserLabelBuilder builder = new UserLabelBuilder(item);
        if (index < 0 || index >= this.userLabels.size()) {
            this._visitables.get((Object)"userLabels").add(builder);
            this.userLabels.add(builder);
        } else {
            this._visitables.get((Object)"userLabels").add(builder);
            this.userLabels.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToUserTags(int index, UserTag item) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        UserTagBuilder builder = new UserTagBuilder(item);
        if (index < 0 || index >= this.userTags.size()) {
            this._visitables.get((Object)"userTags").add(builder);
            this.userTags.add(builder);
        } else {
            this._visitables.get((Object)"userTags").add(builder);
            this.userTags.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeSubnet != null) {
            sb.append("computeSubnet:");
            sb.append(this.computeSubnet);
            sb.append(",");
        }
        if (this.controlPlaneSubnet != null) {
            sb.append("controlPlaneSubnet:");
            sb.append(this.controlPlaneSubnet);
            sb.append(",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append((Object)this.defaultMachinePlatform);
            sb.append(",");
        }
        if (this.dns != null) {
            sb.append("dns:");
            sb.append((Object)this.dns);
            sb.append(",");
        }
        if (this.endpoint != null) {
            sb.append("endpoint:");
            sb.append((Object)this.endpoint);
            sb.append(",");
        }
        if (this.firewallRulesManagement != null) {
            sb.append("firewallRulesManagement:");
            sb.append(this.firewallRulesManagement);
            sb.append(",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network);
            sb.append(",");
        }
        if (this.networkProjectID != null) {
            sb.append("networkProjectID:");
            sb.append(this.networkProjectID);
            sb.append(",");
        }
        if (this.projectID != null) {
            sb.append("projectID:");
            sb.append(this.projectID);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region);
            sb.append(",");
        }
        if (this.userLabels != null && !this.userLabels.isEmpty()) {
            sb.append("userLabels:");
            sb.append(this.userLabels);
            sb.append(",");
        }
        if (this.userProvisionedDNS != null) {
            sb.append("userProvisionedDNS:");
            sb.append(this.userProvisionedDNS);
            sb.append(",");
        }
        if (this.userTags != null && !this.userTags.isEmpty()) {
            sb.append("userTags:");
            sb.append(this.userTags);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withComputeSubnet(String computeSubnet) {
        this.computeSubnet = computeSubnet;
        return (A)((Object)this);
    }

    public A withControlPlaneSubnet(String controlPlaneSubnet) {
        this.controlPlaneSubnet = controlPlaneSubnet;
        return (A)((Object)this);
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove((Object)"defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get((Object)"defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get((Object)"defaultMachinePlatform").remove((Object)this.defaultMachinePlatform);
        }
        return (A)((Object)this);
    }

    public A withDns(DNS dns) {
        this._visitables.remove((Object)"dns");
        if (dns != null) {
            this.dns = new DNSBuilder(dns);
            this._visitables.get((Object)"dns").add(this.dns);
        } else {
            this.dns = null;
            this._visitables.get((Object)"dns").remove((Object)this.dns);
        }
        return (A)((Object)this);
    }

    public A withEndpoint(PSCEndpoint endpoint) {
        this._visitables.remove((Object)"endpoint");
        if (endpoint != null) {
            this.endpoint = new PSCEndpointBuilder(endpoint);
            this._visitables.get((Object)"endpoint").add(this.endpoint);
        } else {
            this.endpoint = null;
            this._visitables.get((Object)"endpoint").remove((Object)this.endpoint);
        }
        return (A)((Object)this);
    }

    public A withFirewallRulesManagement(String firewallRulesManagement) {
        this.firewallRulesManagement = firewallRulesManagement;
        return (A)((Object)this);
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)((Object)this);
    }

    public A withNetworkProjectID(String networkProjectID) {
        this.networkProjectID = networkProjectID;
        return (A)((Object)this);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DnsNested<A> withNewDns() {
        return new DnsNested(null);
    }

    public DnsNested<A> withNewDnsLike(DNS item) {
        return new DnsNested(item);
    }

    public EndpointNested<A> withNewEndpoint() {
        return new EndpointNested(null);
    }

    public A withNewEndpoint(Boolean clusterUseOnly, String name, String region) {
        return this.withEndpoint(new PSCEndpoint(clusterUseOnly, name, region));
    }

    public EndpointNested<A> withNewEndpointLike(PSCEndpoint item) {
        return new EndpointNested(item);
    }

    public A withProjectID(String projectID) {
        this.projectID = projectID;
        return (A)((Object)this);
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public A withUserLabels(List<UserLabel> userLabels) {
        if (this.userLabels != null) {
            this._visitables.get((Object)"userLabels").clear();
        }
        if (userLabels != null) {
            this.userLabels = new ArrayList();
            for (UserLabel item : userLabels) {
                this.addToUserLabels(item);
            }
        } else {
            this.userLabels = null;
        }
        return (A)((Object)this);
    }

    public A withUserLabels(UserLabel ... userLabels) {
        if (this.userLabels != null) {
            this.userLabels.clear();
            this._visitables.remove((Object)"userLabels");
        }
        if (userLabels != null) {
            for (UserLabel item : userLabels) {
                this.addToUserLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public A withUserProvisionedDNS(String userProvisionedDNS) {
        this.userProvisionedDNS = userProvisionedDNS;
        return (A)((Object)this);
    }

    public A withUserTags(List<UserTag> userTags) {
        if (this.userTags != null) {
            this._visitables.get((Object)"userTags").clear();
        }
        if (userTags != null) {
            this.userTags = new ArrayList();
            for (UserTag item : userTags) {
                this.addToUserTags(item);
            }
        } else {
            this.userTags = null;
        }
        return (A)((Object)this);
    }

    public A withUserTags(UserTag ... userTags) {
        if (this.userTags != null) {
            this.userTags.clear();
            this._visitables.remove((Object)"userTags");
        }
        if (userTags != null) {
            for (UserTag item : userTags) {
                this.addToUserTags(item);
            }
        }
        return (A)((Object)this);
    }

    public class UserTagsNested<N>
    extends UserTagFluent<UserTagsNested<N>>
    implements Nested<N> {
        UserTagBuilder builder;
        int index;

        UserTagsNested(int index, UserTag item) {
            this.index = index;
            this.builder = new UserTagBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.setToUserTags(this.index, this.builder.build());
        }

        public N endUserTag() {
            return this.and();
        }
    }

    public class UserLabelsNested<N>
    extends UserLabelFluent<UserLabelsNested<N>>
    implements Nested<N> {
        UserLabelBuilder builder;
        int index;

        UserLabelsNested(int index, UserLabel item) {
            this.index = index;
            this.builder = new UserLabelBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.setToUserLabels(this.index, this.builder.build());
        }

        public N endUserLabel() {
            return this.and();
        }
    }

    public class EndpointNested<N>
    extends PSCEndpointFluent<EndpointNested<N>>
    implements Nested<N> {
        PSCEndpointBuilder builder;

        EndpointNested(PSCEndpoint item) {
            this.builder = new PSCEndpointBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withEndpoint(this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }

    public class DnsNested<N>
    extends DNSFluent<DnsNested<N>>
    implements Nested<N> {
        DNSBuilder builder;

        DnsNested(DNS item) {
            this.builder = new DNSBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withDns(this.builder.build());
        }

        public N endDns() {
            return this.and();
        }
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

