package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EC2RootVolumeFluent<A extends io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolumeFluent<A>> extends BaseFluent<A>{

  private Map<String,Object> additionalProperties;
  private Integer iops;
  private String kmsKeyARN;
  private Integer size;
  private Long throughput;
  private String type;

  public EC2RootVolumeFluent() {
  }
  
  public EC2RootVolumeFluent(EC2RootVolume instance) {
    this.copyInstance(instance);
  }

  public A addToAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null && map != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (map != null) {
      this.additionalProperties.putAll(map);
    }
    return (A) this;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if (this.additionalProperties == null && key != null && value != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (key != null && value != null) {
      this.additionalProperties.put(key, value);
    }
    return (A) this;
  }
  
  protected void copyInstance(EC2RootVolume instance) {
    instance = instance != null ? instance : new EC2RootVolume();
    if (instance != null) {
        this.withIops(instance.getIops());
        this.withKmsKeyARN(instance.getKmsKeyARN());
        this.withSize(instance.getSize());
        this.withThroughput(instance.getThroughput());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }
    if (!(super.equals(o))) {
      return false;
    }
    EC2RootVolumeFluent that = (EC2RootVolumeFluent) o;
    if (!(Objects.equals(iops, that.iops))) {
      return false;
    }
    if (!(Objects.equals(kmsKeyARN, that.kmsKeyARN))) {
      return false;
    }
    if (!(Objects.equals(size, that.size))) {
      return false;
    }
    if (!(Objects.equals(throughput, that.throughput))) {
      return false;
    }
    if (!(Objects.equals(type, that.type))) {
      return false;
    }
    if (!(Objects.equals(additionalProperties, that.additionalProperties))) {
      return false;
    }
    return true;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public Integer getIops() {
    return this.iops;
  }
  
  public String getKmsKeyARN() {
    return this.kmsKeyARN;
  }
  
  public Integer getSize() {
    return this.size;
  }
  
  public Long getThroughput() {
    return this.throughput;
  }
  
  public String getType() {
    return this.type;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean hasIops() {
    return this.iops != null;
  }
  
  public boolean hasKmsKeyARN() {
    return this.kmsKeyARN != null;
  }
  
  public boolean hasSize() {
    return this.size != null;
  }
  
  public boolean hasThroughput() {
    return this.throughput != null;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public int hashCode() {
    return Objects.hash(iops, kmsKeyARN, size, throughput, type, additionalProperties);
  }
  
  public A removeFromAdditionalProperties(String key) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (key != null && this.additionalProperties != null) {
      this.additionalProperties.remove(key);
    }
    return (A) this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (map != null) {
      for (Object key : map.keySet()) {
        if (this.additionalProperties != null) {
          this.additionalProperties.remove(key);
        }
      }
    }
    return (A) this;
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (!(iops == null)) {
        sb.append("iops:");
        sb.append(iops);
        sb.append(",");
    }
    if (!(kmsKeyARN == null)) {
        sb.append("kmsKeyARN:");
        sb.append(kmsKeyARN);
        sb.append(",");
    }
    if (!(size == null)) {
        sb.append("size:");
        sb.append(size);
        sb.append(",");
    }
    if (!(throughput == null)) {
        sb.append("throughput:");
        sb.append(throughput);
        sb.append(",");
    }
    if (!(type == null)) {
        sb.append("type:");
        sb.append(type);
        sb.append(",");
    }
    if (!(additionalProperties == null) && !(additionalProperties.isEmpty())) {
        sb.append("additionalProperties:");
        sb.append(additionalProperties);
    }
    sb.append("}");
    return sb.toString();
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public A withIops(Integer iops) {
    this.iops = iops;
    return (A) this;
  }
  
  public A withKmsKeyARN(String kmsKeyARN) {
    this.kmsKeyARN = kmsKeyARN;
    return (A) this;
  }
  
  public A withSize(Integer size) {
    this.size = size;
    return (A) this;
  }
  
  public A withThroughput(Long throughput) {
    this.throughput = throughput;
    return (A) this;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
}