package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineHealthCheckStatusBuilder extends MachineHealthCheckStatusFluent<MachineHealthCheckStatusBuilder> implements VisitableBuilder<MachineHealthCheckStatus,MachineHealthCheckStatusBuilder>{
  public MachineHealthCheckStatusBuilder() {
    this(new MachineHealthCheckStatus());
  }
  
  public MachineHealthCheckStatusBuilder(MachineHealthCheckStatusFluent<?> fluent) {
    this(fluent, new MachineHealthCheckStatus());
  }
  
  public MachineHealthCheckStatusBuilder(MachineHealthCheckStatusFluent<?> fluent,MachineHealthCheckStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineHealthCheckStatusBuilder(MachineHealthCheckStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineHealthCheckStatusFluent<?> fluent;
  
  public MachineHealthCheckStatus build() {
    MachineHealthCheckStatus buildable = new MachineHealthCheckStatus(fluent.buildConditions(),fluent.getCurrentHealthy(),fluent.getExpectedMachines(),fluent.getRemediationsAllowed());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}