package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineHealthCheckListBuilder extends MachineHealthCheckListFluentImpl<MachineHealthCheckListBuilder> implements VisitableBuilder<MachineHealthCheckList,MachineHealthCheckListBuilder>{
  public MachineHealthCheckListBuilder() {
    this(false);
  }
  public MachineHealthCheckListBuilder(Boolean validationEnabled) {
    this(new MachineHealthCheckList(), validationEnabled);
  }
  public MachineHealthCheckListBuilder(MachineHealthCheckListFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineHealthCheckListBuilder(MachineHealthCheckListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineHealthCheckList(), validationEnabled);
  }
  public MachineHealthCheckListBuilder(MachineHealthCheckListFluent<?> fluent,MachineHealthCheckList instance) {
    this(fluent, instance, false);
  }
  public MachineHealthCheckListBuilder(MachineHealthCheckListFluent<?> fluent,MachineHealthCheckList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineHealthCheckListBuilder(MachineHealthCheckList instance) {
    this(instance,false);
  }
  public MachineHealthCheckListBuilder(MachineHealthCheckList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineHealthCheckListFluent<?> fluent;
  Boolean validationEnabled;
  public MachineHealthCheckList build() {
    MachineHealthCheckList buildable = new MachineHealthCheckList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}