package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.NodeAddress;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface MachineStatusFluent<A extends MachineStatusFluent<A>> extends Fluent<A>{
  public A addToAddresses(int index,NodeAddress item);
  public A setToAddresses(int index,NodeAddress item);
  public A addToAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items);
  public A addAllToAddresses(Collection<NodeAddress> items);
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items);
  public A removeAllFromAddresses(Collection<NodeAddress> items);
  public List<NodeAddress> getAddresses();
  public NodeAddress getAddress(int index);
  public NodeAddress getFirstAddress();
  public NodeAddress getLastAddress();
  public NodeAddress getMatchingAddress(Predicate<NodeAddress> predicate);
  public Boolean hasMatchingAddress(Predicate<NodeAddress> predicate);
  public A withAddresses(List<NodeAddress> addresses);
  public A withAddresses(io.fabric8.kubernetes.api.model.NodeAddress... addresses);
  public Boolean hasAddresses();
  public A addNewAddress(String address,String type);
  public A addToConditions(int index,Condition item);
  public A setToConditions(int index,Condition item);
  public A addToConditions(io.fabric8.openshift.api.model.machine.v1beta1.Condition... items);
  public A addAllToConditions(Collection<Condition> items);
  public A removeFromConditions(io.fabric8.openshift.api.model.machine.v1beta1.Condition... items);
  public A removeAllFromConditions(Collection<Condition> items);
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions();
  public List<Condition> buildConditions();
  public Condition buildCondition(int index);
  public Condition buildFirstCondition();
  public Condition buildLastCondition();
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate);
  public A withConditions(List<Condition> conditions);
  public A withConditions(io.fabric8.openshift.api.model.machine.v1beta1.Condition... conditions);
  public Boolean hasConditions();
  public MachineStatusFluent.ConditionsNested<A> addNewCondition();
  public MachineStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
  public MachineStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item);
  public MachineStatusFluent.ConditionsNested<A> editCondition(int index);
  public MachineStatusFluent.ConditionsNested<A> editFirstCondition();
  public MachineStatusFluent.ConditionsNested<A> editLastCondition();
  public MachineStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate);
  public String getErrorMessage();
  public A withErrorMessage(String errorMessage);
  public Boolean hasErrorMessage();
  public String getErrorReason();
  public A withErrorReason(String errorReason);
  public Boolean hasErrorReason();
  
  /**
   * This method has been deprecated, please use method buildLastOperation instead.
   * @return The buildable object.
   */
  @Deprecated
  public LastOperation getLastOperation();
  public LastOperation buildLastOperation();
  public A withLastOperation(LastOperation lastOperation);
  public Boolean hasLastOperation();
  public A withNewLastOperation(String description,String lastUpdated,String state,String type);
  public MachineStatusFluent.LastOperationNested<A> withNewLastOperation();
  public MachineStatusFluent.LastOperationNested<A> withNewLastOperationLike(LastOperation item);
  public MachineStatusFluent.LastOperationNested<A> editLastOperation();
  public MachineStatusFluent.LastOperationNested<A> editOrNewLastOperation();
  public MachineStatusFluent.LastOperationNested<A> editOrNewLastOperationLike(LastOperation item);
  public String getLastUpdated();
  public A withLastUpdated(String lastUpdated);
  public Boolean hasLastUpdated();
  
  /**
   * This method has been deprecated, please use method buildNodeRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getNodeRef();
  public ObjectReference buildNodeRef();
  public A withNodeRef(ObjectReference nodeRef);
  public Boolean hasNodeRef();
  public MachineStatusFluent.NodeRefNested<A> withNewNodeRef();
  public MachineStatusFluent.NodeRefNested<A> withNewNodeRefLike(ObjectReference item);
  public MachineStatusFluent.NodeRefNested<A> editNodeRef();
  public MachineStatusFluent.NodeRefNested<A> editOrNewNodeRef();
  public MachineStatusFluent.NodeRefNested<A> editOrNewNodeRefLike(ObjectReference item);
  public String getPhase();
  public A withPhase(String phase);
  public Boolean hasPhase();
  public A addToProviderStatus(String key,Object value);
  public A addToProviderStatus(Map<String,Object> map);
  public A removeFromProviderStatus(String key);
  public A removeFromProviderStatus(Map<String,Object> map);
  public Map<String,Object> getProviderStatus();
  public <K,V>A withProviderStatus(Map<String,Object> providerStatus);
  public Boolean hasProviderStatus();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,ConditionFluent<MachineStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface LastOperationNested<N> extends Nested<N>,LastOperationFluent<MachineStatusFluent.LastOperationNested<N>>{
    public N and();
    public N endLastOperation();
    
  }
  public interface NodeRefNested<N> extends Nested<N>,ObjectReferenceFluent<MachineStatusFluent.NodeRefNested<N>>{
    public N and();
    public N endNodeRef();
    
  }
  
}