/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.AzureBootDiagnostics;
import io.fabric8.openshift.api.model.machine.v1beta1.AzureCustomerManagedBootDiagnostics;
import io.fabric8.openshift.api.model.machine.v1beta1.AzureCustomerManagedBootDiagnosticsBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.AzureCustomerManagedBootDiagnosticsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AzureBootDiagnosticsFluent<A extends AzureBootDiagnosticsFluent<A>>
extends BaseFluent<A> {
    private AzureCustomerManagedBootDiagnosticsBuilder customerManaged;
    private String storageAccountType;
    private Map<String, Object> additionalProperties;

    public AzureBootDiagnosticsFluent() {
    }

    public AzureBootDiagnosticsFluent(AzureBootDiagnostics instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AzureBootDiagnostics instance) {
        AzureBootDiagnostics azureBootDiagnostics = instance = instance != null ? instance : new AzureBootDiagnostics();
        if (instance != null) {
            this.withCustomerManaged(instance.getCustomerManaged());
            this.withStorageAccountType(instance.getStorageAccountType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AzureCustomerManagedBootDiagnostics buildCustomerManaged() {
        return this.customerManaged != null ? this.customerManaged.build() : null;
    }

    public A withCustomerManaged(AzureCustomerManagedBootDiagnostics customerManaged) {
        this._visitables.remove((Object)"customerManaged");
        if (customerManaged != null) {
            this.customerManaged = new AzureCustomerManagedBootDiagnosticsBuilder(customerManaged);
            this._visitables.get((Object)"customerManaged").add(this.customerManaged);
        } else {
            this.customerManaged = null;
            this._visitables.get((Object)"customerManaged").remove((Object)this.customerManaged);
        }
        return (A)((Object)this);
    }

    public boolean hasCustomerManaged() {
        return this.customerManaged != null;
    }

    public A withNewCustomerManaged(String storageAccountURI) {
        return this.withCustomerManaged(new AzureCustomerManagedBootDiagnostics(storageAccountURI));
    }

    public CustomerManagedNested<A> withNewCustomerManaged() {
        return new CustomerManagedNested(null);
    }

    public CustomerManagedNested<A> withNewCustomerManagedLike(AzureCustomerManagedBootDiagnostics item) {
        return new CustomerManagedNested(item);
    }

    public CustomerManagedNested<A> editCustomerManaged() {
        return this.withNewCustomerManagedLike(Optional.ofNullable(this.buildCustomerManaged()).orElse(null));
    }

    public CustomerManagedNested<A> editOrNewCustomerManaged() {
        return this.withNewCustomerManagedLike(Optional.ofNullable(this.buildCustomerManaged()).orElse(new AzureCustomerManagedBootDiagnosticsBuilder().build()));
    }

    public CustomerManagedNested<A> editOrNewCustomerManagedLike(AzureCustomerManagedBootDiagnostics item) {
        return this.withNewCustomerManagedLike(Optional.ofNullable(this.buildCustomerManaged()).orElse(item));
    }

    public String getStorageAccountType() {
        return this.storageAccountType;
    }

    public A withStorageAccountType(String storageAccountType) {
        this.storageAccountType = storageAccountType;
        return (A)((Object)this);
    }

    public boolean hasStorageAccountType() {
        return this.storageAccountType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureBootDiagnosticsFluent that = (AzureBootDiagnosticsFluent)((Object)o);
        if (!Objects.equals((Object)this.customerManaged, (Object)that.customerManaged)) {
            return false;
        }
        if (!Objects.equals(this.storageAccountType, that.storageAccountType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customerManaged, this.storageAccountType, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.customerManaged != null) {
            sb.append("customerManaged:");
            sb.append(this.customerManaged + ",");
        }
        if (this.storageAccountType != null) {
            sb.append("storageAccountType:");
            sb.append(this.storageAccountType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CustomerManagedNested<N>
    extends AzureCustomerManagedBootDiagnosticsFluent<CustomerManagedNested<N>>
    implements Nested<N> {
        AzureCustomerManagedBootDiagnosticsBuilder builder;

        CustomerManagedNested(AzureCustomerManagedBootDiagnostics item) {
            this.builder = new AzureCustomerManagedBootDiagnosticsBuilder(this, item);
        }

        public N and() {
            return (N)AzureBootDiagnosticsFluent.this.withCustomerManaged(this.builder.build());
        }

        public N endCustomerManaged() {
            return this.and();
        }
    }
}

