package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ControllerConfigSpecBuilder extends ControllerConfigSpecFluent<ControllerConfigSpecBuilder> implements VisitableBuilder<ControllerConfigSpec,ControllerConfigSpecBuilder>{
  public ControllerConfigSpecBuilder() {
    this(new ControllerConfigSpec());
  }
  
  public ControllerConfigSpecBuilder(ControllerConfigSpecFluent<?> fluent) {
    this(fluent, new ControllerConfigSpec());
  }
  
  public ControllerConfigSpecBuilder(ControllerConfigSpecFluent<?> fluent,ControllerConfigSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ControllerConfigSpecBuilder(ControllerConfigSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ControllerConfigSpecFluent<?> fluent;
  
  public ControllerConfigSpec build() {
    ControllerConfigSpec buildable = new ControllerConfigSpec(fluent.getAdditionalTrustBundle(),fluent.getBaseOSContainerImage(),fluent.getBaseOSExtensionsContainerImage(),fluent.getCloudProviderCAData(),fluent.getCloudProviderConfig(),fluent.getClusterDNSIP(),fluent.getDns(),fluent.getEtcdDiscoveryDomain(),fluent.buildImageRegistryBundleData(),fluent.buildImageRegistryBundleUserData(),fluent.getImages(),fluent.getInfra(),fluent.getIpFamilies(),fluent.getKubeAPIServerServingCAData(),fluent.buildNetwork(),fluent.getNetworkType(),fluent.getOsImageURL(),fluent.getPlatform(),fluent.getProxy(),fluent.buildPullSecret(),fluent.getReleaseImage(),fluent.getRootCAData());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}