package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerRuntimeConfigConditionBuilder extends ContainerRuntimeConfigConditionFluentImpl<ContainerRuntimeConfigConditionBuilder> implements VisitableBuilder<ContainerRuntimeConfigCondition,ContainerRuntimeConfigConditionBuilder>{
  public ContainerRuntimeConfigConditionBuilder() {
    this(false);
  }
  public ContainerRuntimeConfigConditionBuilder(Boolean validationEnabled) {
    this(new ContainerRuntimeConfigCondition(), validationEnabled);
  }
  public ContainerRuntimeConfigConditionBuilder(ContainerRuntimeConfigConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerRuntimeConfigConditionBuilder(ContainerRuntimeConfigConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerRuntimeConfigCondition(), validationEnabled);
  }
  public ContainerRuntimeConfigConditionBuilder(ContainerRuntimeConfigConditionFluent<?> fluent,ContainerRuntimeConfigCondition instance) {
    this(fluent, instance, false);
  }
  public ContainerRuntimeConfigConditionBuilder(ContainerRuntimeConfigConditionFluent<?> fluent,ContainerRuntimeConfigCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerRuntimeConfigConditionBuilder(ContainerRuntimeConfigCondition instance) {
    this(instance,false);
  }
  public ContainerRuntimeConfigConditionBuilder(ContainerRuntimeConfigCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ContainerRuntimeConfigConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerRuntimeConfigCondition build() {
    ContainerRuntimeConfigCondition buildable = new ContainerRuntimeConfigCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}