package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfile;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KubeletConfigSpecFluentImpl<A extends KubeletConfigSpecFluent<A>> extends BaseFluent<A> implements KubeletConfigSpecFluent<A>{
  public KubeletConfigSpecFluentImpl() {
  }
  public KubeletConfigSpecFluentImpl(KubeletConfigSpec instance) {
    this.withAutoSizingReserved(instance.getAutoSizingReserved()); 
    this.withKubeletConfig(instance.getKubeletConfig()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector()); 
    this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean autoSizingReserved;
  private Map<String,Object> kubeletConfig;
  private Integer logLevel;
  private LabelSelectorBuilder machineConfigPoolSelector;
  private TLSSecurityProfile tlsSecurityProfile;
  private Map<String,Object> additionalProperties;
  public Boolean getAutoSizingReserved() {
    return this.autoSizingReserved;
  }
  public A withAutoSizingReserved(Boolean autoSizingReserved) {
    this.autoSizingReserved=autoSizingReserved; return (A) this;
  }
  public Boolean hasAutoSizingReserved() {
    return this.autoSizingReserved != null;
  }
  public A addToKubeletConfig(String key,Object value) {
    if(this.kubeletConfig == null && key != null && value != null) { this.kubeletConfig = new LinkedHashMap(); }
    if(key != null && value != null) {this.kubeletConfig.put(key, value);} return (A)this;
  }
  public A addToKubeletConfig(Map<String,Object> map) {
    if(this.kubeletConfig == null && map != null) { this.kubeletConfig = new LinkedHashMap(); }
    if(map != null) { this.kubeletConfig.putAll(map);} return (A)this;
  }
  public A removeFromKubeletConfig(String key) {
    if(this.kubeletConfig == null) { return (A) this; }
    if(key != null && this.kubeletConfig != null) {this.kubeletConfig.remove(key);} return (A)this;
  }
  public A removeFromKubeletConfig(Map<String,Object> map) {
    if(this.kubeletConfig == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.kubeletConfig != null){this.kubeletConfig.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getKubeletConfig() {
    return this.kubeletConfig;
  }
  public <K,V>A withKubeletConfig(Map<String,Object> kubeletConfig) {
    if (kubeletConfig == null) { this.kubeletConfig =  null;} else {this.kubeletConfig = new LinkedHashMap(kubeletConfig);} return (A) this;
  }
  public Boolean hasKubeletConfig() {
    return this.kubeletConfig != null;
  }
  public Integer getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(Integer logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMachineConfigPoolSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getMachineConfigPoolSelector() {
    return this.machineConfigPoolSelector!=null ?this.machineConfigPoolSelector.build():null;
  }
  public LabelSelector buildMachineConfigPoolSelector() {
    return this.machineConfigPoolSelector!=null ?this.machineConfigPoolSelector.build():null;
  }
  public A withMachineConfigPoolSelector(LabelSelector machineConfigPoolSelector) {
    _visitables.get("machineConfigPoolSelector").remove(this.machineConfigPoolSelector);
    if (machineConfigPoolSelector!=null){ this.machineConfigPoolSelector= new LabelSelectorBuilder(machineConfigPoolSelector); _visitables.get("machineConfigPoolSelector").add(this.machineConfigPoolSelector);} else { this.machineConfigPoolSelector = null; _visitables.get("machineConfigPoolSelector").remove(this.machineConfigPoolSelector); } return (A) this;
  }
  public Boolean hasMachineConfigPoolSelector() {
    return this.machineConfigPoolSelector != null;
  }
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelector() {
    return new KubeletConfigSpecFluentImpl.MachineConfigPoolSelectorNestedImpl();
  }
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelectorLike(LabelSelector item) {
    return new KubeletConfigSpecFluentImpl.MachineConfigPoolSelectorNestedImpl(item);
  }
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> editMachineConfigPoolSelector() {
    return withNewMachineConfigPoolSelectorLike(getMachineConfigPoolSelector());
  }
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelector() {
    return withNewMachineConfigPoolSelectorLike(getMachineConfigPoolSelector() != null ? getMachineConfigPoolSelector(): new LabelSelectorBuilder().build());
  }
  public KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelectorLike(LabelSelector item) {
    return withNewMachineConfigPoolSelectorLike(getMachineConfigPoolSelector() != null ? getMachineConfigPoolSelector(): item);
  }
  public TLSSecurityProfile getTlsSecurityProfile() {
    return this.tlsSecurityProfile;
  }
  public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
    this.tlsSecurityProfile=tlsSecurityProfile; return (A) this;
  }
  public Boolean hasTlsSecurityProfile() {
    return this.tlsSecurityProfile != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KubeletConfigSpecFluentImpl that = (KubeletConfigSpecFluentImpl) o;
    if (autoSizingReserved != null ? !autoSizingReserved.equals(that.autoSizingReserved) :that.autoSizingReserved != null) return false;
    if (kubeletConfig != null ? !kubeletConfig.equals(that.kubeletConfig) :that.kubeletConfig != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (machineConfigPoolSelector != null ? !machineConfigPoolSelector.equals(that.machineConfigPoolSelector) :that.machineConfigPoolSelector != null) return false;
    if (tlsSecurityProfile != null ? !tlsSecurityProfile.equals(that.tlsSecurityProfile) :that.tlsSecurityProfile != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(autoSizingReserved,  kubeletConfig,  logLevel,  machineConfigPoolSelector,  tlsSecurityProfile,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (autoSizingReserved != null) { sb.append("autoSizingReserved:"); sb.append(autoSizingReserved + ","); }
    if (kubeletConfig != null && !kubeletConfig.isEmpty()) { sb.append("kubeletConfig:"); sb.append(kubeletConfig + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (machineConfigPoolSelector != null) { sb.append("machineConfigPoolSelector:"); sb.append(machineConfigPoolSelector + ","); }
    if (tlsSecurityProfile != null) { sb.append("tlsSecurityProfile:"); sb.append(tlsSecurityProfile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAutoSizingReserved() {
    return withAutoSizingReserved(true);
  }
  class MachineConfigPoolSelectorNestedImpl<N> extends LabelSelectorFluentImpl<KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<N>> implements KubeletConfigSpecFluent.MachineConfigPoolSelectorNested<N>,Nested<N>{
    MachineConfigPoolSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    MachineConfigPoolSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) KubeletConfigSpecFluentImpl.this.withMachineConfigPoolSelector(builder.build());
    }
    public N endMachineConfigPoolSelector() {
      return and();
    }
    
  }
  
}