package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachineConfigPoolSpecFluentImpl<A extends MachineConfigPoolSpecFluent<A>> extends BaseFluent<A> implements MachineConfigPoolSpecFluent<A>{
  public MachineConfigPoolSpecFluentImpl() {
  }
  public MachineConfigPoolSpecFluentImpl(MachineConfigPoolSpec instance) {
    this.withConfiguration(instance.getConfiguration()); 
    this.withMachineConfigSelector(instance.getMachineConfigSelector()); 
    this.withMaxUnavailable(instance.getMaxUnavailable()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withPaused(instance.getPaused()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private MachineConfigPoolStatusConfigurationBuilder configuration;
  private LabelSelectorBuilder machineConfigSelector;
  private IntOrStringBuilder maxUnavailable;
  private LabelSelectorBuilder nodeSelector;
  private Boolean paused;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachineConfigPoolStatusConfiguration getConfiguration() {
    return this.configuration!=null ?this.configuration.build():null;
  }
  public MachineConfigPoolStatusConfiguration buildConfiguration() {
    return this.configuration!=null ?this.configuration.build():null;
  }
  public A withConfiguration(MachineConfigPoolStatusConfiguration configuration) {
    _visitables.get("configuration").remove(this.configuration);
    if (configuration!=null){ this.configuration= new MachineConfigPoolStatusConfigurationBuilder(configuration); _visitables.get("configuration").add(this.configuration);} else { this.configuration = null; _visitables.get("configuration").remove(this.configuration); } return (A) this;
  }
  public Boolean hasConfiguration() {
    return this.configuration != null;
  }
  public MachineConfigPoolSpecFluent.ConfigurationNested<A> withNewConfiguration() {
    return new MachineConfigPoolSpecFluentImpl.ConfigurationNestedImpl();
  }
  public MachineConfigPoolSpecFluent.ConfigurationNested<A> withNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
    return new MachineConfigPoolSpecFluentImpl.ConfigurationNestedImpl(item);
  }
  public MachineConfigPoolSpecFluent.ConfigurationNested<A> editConfiguration() {
    return withNewConfigurationLike(getConfiguration());
  }
  public MachineConfigPoolSpecFluent.ConfigurationNested<A> editOrNewConfiguration() {
    return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new MachineConfigPoolStatusConfigurationBuilder().build());
  }
  public MachineConfigPoolSpecFluent.ConfigurationNested<A> editOrNewConfigurationLike(MachineConfigPoolStatusConfiguration item) {
    return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMachineConfigSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getMachineConfigSelector() {
    return this.machineConfigSelector!=null ?this.machineConfigSelector.build():null;
  }
  public LabelSelector buildMachineConfigSelector() {
    return this.machineConfigSelector!=null ?this.machineConfigSelector.build():null;
  }
  public A withMachineConfigSelector(LabelSelector machineConfigSelector) {
    _visitables.get("machineConfigSelector").remove(this.machineConfigSelector);
    if (machineConfigSelector!=null){ this.machineConfigSelector= new LabelSelectorBuilder(machineConfigSelector); _visitables.get("machineConfigSelector").add(this.machineConfigSelector);} else { this.machineConfigSelector = null; _visitables.get("machineConfigSelector").remove(this.machineConfigSelector); } return (A) this;
  }
  public Boolean hasMachineConfigSelector() {
    return this.machineConfigSelector != null;
  }
  public MachineConfigPoolSpecFluent.MachineConfigSelectorNested<A> withNewMachineConfigSelector() {
    return new MachineConfigPoolSpecFluentImpl.MachineConfigSelectorNestedImpl();
  }
  public MachineConfigPoolSpecFluent.MachineConfigSelectorNested<A> withNewMachineConfigSelectorLike(LabelSelector item) {
    return new MachineConfigPoolSpecFluentImpl.MachineConfigSelectorNestedImpl(item);
  }
  public MachineConfigPoolSpecFluent.MachineConfigSelectorNested<A> editMachineConfigSelector() {
    return withNewMachineConfigSelectorLike(getMachineConfigSelector());
  }
  public MachineConfigPoolSpecFluent.MachineConfigSelectorNested<A> editOrNewMachineConfigSelector() {
    return withNewMachineConfigSelectorLike(getMachineConfigSelector() != null ? getMachineConfigSelector(): new LabelSelectorBuilder().build());
  }
  public MachineConfigPoolSpecFluent.MachineConfigSelectorNested<A> editOrNewMachineConfigSelectorLike(LabelSelector item) {
    return withNewMachineConfigSelectorLike(getMachineConfigSelector() != null ? getMachineConfigSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMaxUnavailable instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getMaxUnavailable() {
    return this.maxUnavailable!=null ?this.maxUnavailable.build():null;
  }
  public IntOrString buildMaxUnavailable() {
    return this.maxUnavailable!=null ?this.maxUnavailable.build():null;
  }
  public A withMaxUnavailable(IntOrString maxUnavailable) {
    _visitables.get("maxUnavailable").remove(this.maxUnavailable);
    if (maxUnavailable!=null){ this.maxUnavailable= new IntOrStringBuilder(maxUnavailable); _visitables.get("maxUnavailable").add(this.maxUnavailable);} else { this.maxUnavailable = null; _visitables.get("maxUnavailable").remove(this.maxUnavailable); } return (A) this;
  }
  public Boolean hasMaxUnavailable() {
    return this.maxUnavailable != null;
  }
  public A withNewMaxUnavailable(Object value) {
    return (A)withMaxUnavailable(new IntOrString(value));
  }
  public MachineConfigPoolSpecFluent.MaxUnavailableNested<A> withNewMaxUnavailable() {
    return new MachineConfigPoolSpecFluentImpl.MaxUnavailableNestedImpl();
  }
  public MachineConfigPoolSpecFluent.MaxUnavailableNested<A> withNewMaxUnavailableLike(IntOrString item) {
    return new MachineConfigPoolSpecFluentImpl.MaxUnavailableNestedImpl(item);
  }
  public MachineConfigPoolSpecFluent.MaxUnavailableNested<A> editMaxUnavailable() {
    return withNewMaxUnavailableLike(getMaxUnavailable());
  }
  public MachineConfigPoolSpecFluent.MaxUnavailableNested<A> editOrNewMaxUnavailable() {
    return withNewMaxUnavailableLike(getMaxUnavailable() != null ? getMaxUnavailable(): new IntOrStringBuilder().build());
  }
  public MachineConfigPoolSpecFluent.MaxUnavailableNested<A> editOrNewMaxUnavailableLike(IntOrString item) {
    return withNewMaxUnavailableLike(getMaxUnavailable() != null ? getMaxUnavailable(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodeSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNodeSelector() {
    return this.nodeSelector!=null ?this.nodeSelector.build():null;
  }
  public LabelSelector buildNodeSelector() {
    return this.nodeSelector!=null ?this.nodeSelector.build():null;
  }
  public A withNodeSelector(LabelSelector nodeSelector) {
    _visitables.get("nodeSelector").remove(this.nodeSelector);
    if (nodeSelector!=null){ this.nodeSelector= new LabelSelectorBuilder(nodeSelector); _visitables.get("nodeSelector").add(this.nodeSelector);} else { this.nodeSelector = null; _visitables.get("nodeSelector").remove(this.nodeSelector); } return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public MachineConfigPoolSpecFluent.NodeSelectorNested<A> withNewNodeSelector() {
    return new MachineConfigPoolSpecFluentImpl.NodeSelectorNestedImpl();
  }
  public MachineConfigPoolSpecFluent.NodeSelectorNested<A> withNewNodeSelectorLike(LabelSelector item) {
    return new MachineConfigPoolSpecFluentImpl.NodeSelectorNestedImpl(item);
  }
  public MachineConfigPoolSpecFluent.NodeSelectorNested<A> editNodeSelector() {
    return withNewNodeSelectorLike(getNodeSelector());
  }
  public MachineConfigPoolSpecFluent.NodeSelectorNested<A> editOrNewNodeSelector() {
    return withNewNodeSelectorLike(getNodeSelector() != null ? getNodeSelector(): new LabelSelectorBuilder().build());
  }
  public MachineConfigPoolSpecFluent.NodeSelectorNested<A> editOrNewNodeSelectorLike(LabelSelector item) {
    return withNewNodeSelectorLike(getNodeSelector() != null ? getNodeSelector(): item);
  }
  public Boolean getPaused() {
    return this.paused;
  }
  public A withPaused(Boolean paused) {
    this.paused=paused; return (A) this;
  }
  public Boolean hasPaused() {
    return this.paused != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachineConfigPoolSpecFluentImpl that = (MachineConfigPoolSpecFluentImpl) o;
    if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
    if (machineConfigSelector != null ? !machineConfigSelector.equals(that.machineConfigSelector) :that.machineConfigSelector != null) return false;
    if (maxUnavailable != null ? !maxUnavailable.equals(that.maxUnavailable) :that.maxUnavailable != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configuration,  machineConfigSelector,  maxUnavailable,  nodeSelector,  paused,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configuration != null) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (machineConfigSelector != null) { sb.append("machineConfigSelector:"); sb.append(machineConfigSelector + ","); }
    if (maxUnavailable != null) { sb.append("maxUnavailable:"); sb.append(maxUnavailable + ","); }
    if (nodeSelector != null) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withPaused() {
    return withPaused(true);
  }
  class ConfigurationNestedImpl<N> extends MachineConfigPoolStatusConfigurationFluentImpl<MachineConfigPoolSpecFluent.ConfigurationNested<N>> implements MachineConfigPoolSpecFluent.ConfigurationNested<N>,Nested<N>{
    ConfigurationNestedImpl(MachineConfigPoolStatusConfiguration item) {
      this.builder = new MachineConfigPoolStatusConfigurationBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.builder = new MachineConfigPoolStatusConfigurationBuilder(this);
    }
    MachineConfigPoolStatusConfigurationBuilder builder;
    public N and() {
      return (N) MachineConfigPoolSpecFluentImpl.this.withConfiguration(builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  class MachineConfigSelectorNestedImpl<N> extends LabelSelectorFluentImpl<MachineConfigPoolSpecFluent.MachineConfigSelectorNested<N>> implements MachineConfigPoolSpecFluent.MachineConfigSelectorNested<N>,Nested<N>{
    MachineConfigSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    MachineConfigSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) MachineConfigPoolSpecFluentImpl.this.withMachineConfigSelector(builder.build());
    }
    public N endMachineConfigSelector() {
      return and();
    }
    
  }
  class MaxUnavailableNestedImpl<N> extends IntOrStringFluentImpl<MachineConfigPoolSpecFluent.MaxUnavailableNested<N>> implements MachineConfigPoolSpecFluent.MaxUnavailableNested<N>,Nested<N>{
    MaxUnavailableNestedImpl(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    MaxUnavailableNestedImpl() {
      this.builder = new IntOrStringBuilder(this);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) MachineConfigPoolSpecFluentImpl.this.withMaxUnavailable(builder.build());
    }
    public N endMaxUnavailable() {
      return and();
    }
    
  }
  class NodeSelectorNestedImpl<N> extends LabelSelectorFluentImpl<MachineConfigPoolSpecFluent.NodeSelectorNested<N>> implements MachineConfigPoolSpecFluent.NodeSelectorNested<N>,Nested<N>{
    NodeSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    NodeSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) MachineConfigPoolSpecFluentImpl.this.withNodeSelector(builder.build());
    }
    public N endNodeSelector() {
      return and();
    }
    
  }
  
}