package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PinnedImageSetSpecFluent<A extends PinnedImageSetSpecFluent<A>> extends BaseFluent<A>{
  public PinnedImageSetSpecFluent() {
  }
  
  public PinnedImageSetSpecFluent(PinnedImageSetSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<PinnedImageRefBuilder> pinnedImages = new ArrayList<PinnedImageRefBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PinnedImageSetSpec instance) {
    instance = (instance != null ? instance : new PinnedImageSetSpec());
    if (instance != null) {
          this.withPinnedImages(instance.getPinnedImages());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToPinnedImages(int index,PinnedImageRef item) {
    if (this.pinnedImages == null) {this.pinnedImages = new ArrayList<PinnedImageRefBuilder>();}
    PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
    if (index < 0 || index >= pinnedImages.size()) { _visitables.get("pinnedImages").add(builder); pinnedImages.add(builder); } else { _visitables.get("pinnedImages").add(index, builder); pinnedImages.add(index, builder);}
    return (A)this;
  }
  
  public A setToPinnedImages(int index,PinnedImageRef item) {
    if (this.pinnedImages == null) {this.pinnedImages = new ArrayList<PinnedImageRefBuilder>();}
    PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);
    if (index < 0 || index >= pinnedImages.size()) { _visitables.get("pinnedImages").add(builder); pinnedImages.add(builder); } else { _visitables.get("pinnedImages").set(index, builder); pinnedImages.set(index, builder);}
    return (A)this;
  }
  
  public A addToPinnedImages(io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageRef... items) {
    if (this.pinnedImages == null) {this.pinnedImages = new ArrayList<PinnedImageRefBuilder>();}
    for (PinnedImageRef item : items) {PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);_visitables.get("pinnedImages").add(builder);this.pinnedImages.add(builder);} return (A)this;
  }
  
  public A addAllToPinnedImages(Collection<PinnedImageRef> items) {
    if (this.pinnedImages == null) {this.pinnedImages = new ArrayList<PinnedImageRefBuilder>();}
    for (PinnedImageRef item : items) {PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);_visitables.get("pinnedImages").add(builder);this.pinnedImages.add(builder);} return (A)this;
  }
  
  public A removeFromPinnedImages(io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageRef... items) {
    if (this.pinnedImages == null) return (A)this;
    for (PinnedImageRef item : items) {PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);_visitables.get("pinnedImages").remove(builder); this.pinnedImages.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPinnedImages(Collection<PinnedImageRef> items) {
    if (this.pinnedImages == null) return (A)this;
    for (PinnedImageRef item : items) {PinnedImageRefBuilder builder = new PinnedImageRefBuilder(item);_visitables.get("pinnedImages").remove(builder); this.pinnedImages.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPinnedImages(Predicate<PinnedImageRefBuilder> predicate) {
    if (pinnedImages == null) return (A) this;
    final Iterator<PinnedImageRefBuilder> each = pinnedImages.iterator();
    final List visitables = _visitables.get("pinnedImages");
    while (each.hasNext()) {
      PinnedImageRefBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PinnedImageRef> buildPinnedImages() {
    return this.pinnedImages != null ? build(pinnedImages) : null;
  }
  
  public PinnedImageRef buildPinnedImage(int index) {
    return this.pinnedImages.get(index).build();
  }
  
  public PinnedImageRef buildFirstPinnedImage() {
    return this.pinnedImages.get(0).build();
  }
  
  public PinnedImageRef buildLastPinnedImage() {
    return this.pinnedImages.get(pinnedImages.size() - 1).build();
  }
  
  public PinnedImageRef buildMatchingPinnedImage(Predicate<PinnedImageRefBuilder> predicate) {
      for (PinnedImageRefBuilder item : pinnedImages) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPinnedImage(Predicate<PinnedImageRefBuilder> predicate) {
      for (PinnedImageRefBuilder item : pinnedImages) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPinnedImages(List<PinnedImageRef> pinnedImages) {
    if (this.pinnedImages != null) {
      this._visitables.get("pinnedImages").clear();
    }
    if (pinnedImages != null) {
        this.pinnedImages = new ArrayList();
        for (PinnedImageRef item : pinnedImages) {
          this.addToPinnedImages(item);
        }
    } else {
      this.pinnedImages = null;
    }
    return (A) this;
  }
  
  public A withPinnedImages(io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.PinnedImageRef... pinnedImages) {
    if (this.pinnedImages != null) {
        this.pinnedImages.clear();
        _visitables.remove("pinnedImages");
    }
    if (pinnedImages != null) {
      for (PinnedImageRef item : pinnedImages) {
        this.addToPinnedImages(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPinnedImages() {
    return this.pinnedImages != null && !this.pinnedImages.isEmpty();
  }
  
  public A addNewPinnedImage(String name) {
    return (A)addToPinnedImages(new PinnedImageRef(name));
  }
  
  public PinnedImagesNested<A> addNewPinnedImage() {
    return new PinnedImagesNested(-1, null);
  }
  
  public PinnedImagesNested<A> addNewPinnedImageLike(PinnedImageRef item) {
    return new PinnedImagesNested(-1, item);
  }
  
  public PinnedImagesNested<A> setNewPinnedImageLike(int index,PinnedImageRef item) {
    return new PinnedImagesNested(index, item);
  }
  
  public PinnedImagesNested<A> editPinnedImage(int index) {
    if (pinnedImages.size() <= index) throw new RuntimeException("Can't edit pinnedImages. Index exceeds size.");
    return setNewPinnedImageLike(index, buildPinnedImage(index));
  }
  
  public PinnedImagesNested<A> editFirstPinnedImage() {
    if (pinnedImages.size() == 0) throw new RuntimeException("Can't edit first pinnedImages. The list is empty.");
    return setNewPinnedImageLike(0, buildPinnedImage(0));
  }
  
  public PinnedImagesNested<A> editLastPinnedImage() {
    int index = pinnedImages.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pinnedImages. The list is empty.");
    return setNewPinnedImageLike(index, buildPinnedImage(index));
  }
  
  public PinnedImagesNested<A> editMatchingPinnedImage(Predicate<PinnedImageRefBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pinnedImages.size();i++) { 
    if (predicate.test(pinnedImages.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pinnedImages. No match found.");
    return setNewPinnedImageLike(index, buildPinnedImage(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PinnedImageSetSpecFluent that = (PinnedImageSetSpecFluent) o;
    if (!java.util.Objects.equals(pinnedImages, that.pinnedImages)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(pinnedImages,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (pinnedImages != null && !pinnedImages.isEmpty()) { sb.append("pinnedImages:"); sb.append(pinnedImages + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PinnedImagesNested<N> extends PinnedImageRefFluent<PinnedImagesNested<N>> implements Nested<N>{
    PinnedImagesNested(int index,PinnedImageRef item) {
      this.index = index;
      this.builder = new PinnedImageRefBuilder(this, item);
    }
    PinnedImageRefBuilder builder;
    int index;
    
    public N and() {
      return (N) PinnedImageSetSpecFluent.this.setToPinnedImages(index,builder.build());
    }
    
    public N endPinnedImage() {
      return and();
    }
    
  
  }

}