package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MCOObjectReferenceBuilder extends MCOObjectReferenceFluent<MCOObjectReferenceBuilder> implements VisitableBuilder<MCOObjectReference,MCOObjectReferenceBuilder>{
  public MCOObjectReferenceBuilder() {
    this(new MCOObjectReference());
  }
  
  public MCOObjectReferenceBuilder(MCOObjectReferenceFluent<?> fluent) {
    this(fluent, new MCOObjectReference());
  }
  
  public MCOObjectReferenceBuilder(MCOObjectReferenceFluent<?> fluent,MCOObjectReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MCOObjectReferenceBuilder(MCOObjectReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MCOObjectReferenceFluent<?> fluent;
  
  public MCOObjectReference build() {
    MCOObjectReference buildable = new MCOObjectReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}