/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MCOObjectReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MCOObjectReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MCOObjectReferenceFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpec;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecMachineConfigVersion;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecMachineConfigVersionBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecMachineConfigVersionFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineConfigNodeSpecFluent<A extends MachineConfigNodeSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private MachineConfigNodeSpecMachineConfigVersionBuilder configVersion;
    private MCOObjectReferenceBuilder node;
    private MCOObjectReferenceBuilder pool;

    public MachineConfigNodeSpecFluent() {
    }

    public MachineConfigNodeSpecFluent(MachineConfigNodeSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public MachineConfigNodeSpecMachineConfigVersion buildConfigVersion() {
        return this.configVersion != null ? this.configVersion.build() : null;
    }

    public MCOObjectReference buildNode() {
        return this.node != null ? this.node.build() : null;
    }

    public MCOObjectReference buildPool() {
        return this.pool != null ? this.pool.build() : null;
    }

    protected void copyInstance(MachineConfigNodeSpec instance) {
        MachineConfigNodeSpec machineConfigNodeSpec = instance = instance != null ? instance : new MachineConfigNodeSpec();
        if (instance != null) {
            this.withConfigVersion(instance.getConfigVersion());
            this.withNode(instance.getNode());
            this.withPool(instance.getPool());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigVersionNested<A> editConfigVersion() {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(null));
    }

    public NodeNested<A> editNode() {
        return this.withNewNodeLike(Optional.ofNullable(this.buildNode()).orElse(null));
    }

    public ConfigVersionNested<A> editOrNewConfigVersion() {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(new MachineConfigNodeSpecMachineConfigVersionBuilder().build()));
    }

    public ConfigVersionNested<A> editOrNewConfigVersionLike(MachineConfigNodeSpecMachineConfigVersion item) {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(item));
    }

    public NodeNested<A> editOrNewNode() {
        return this.withNewNodeLike(Optional.ofNullable(this.buildNode()).orElse(new MCOObjectReferenceBuilder().build()));
    }

    public NodeNested<A> editOrNewNodeLike(MCOObjectReference item) {
        return this.withNewNodeLike(Optional.ofNullable(this.buildNode()).orElse(item));
    }

    public PoolNested<A> editOrNewPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(new MCOObjectReferenceBuilder().build()));
    }

    public PoolNested<A> editOrNewPoolLike(MCOObjectReference item) {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(item));
    }

    public PoolNested<A> editPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigNodeSpecFluent that = (MachineConfigNodeSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.configVersion, (Object)that.configVersion)) {
            return false;
        }
        if (!Objects.equals((Object)this.node, (Object)that.node)) {
            return false;
        }
        if (!Objects.equals((Object)this.pool, (Object)that.pool)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConfigVersion() {
        return this.configVersion != null;
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configVersion, this.node, this.pool, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configVersion != null) {
            sb.append("configVersion:");
            sb.append((Object)this.configVersion);
            sb.append(",");
        }
        if (this.node != null) {
            sb.append("node:");
            sb.append((Object)this.node);
            sb.append(",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append((Object)this.pool);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConfigVersion(MachineConfigNodeSpecMachineConfigVersion configVersion) {
        this._visitables.remove((Object)"configVersion");
        if (configVersion != null) {
            this.configVersion = new MachineConfigNodeSpecMachineConfigVersionBuilder(configVersion);
            this._visitables.get((Object)"configVersion").add(this.configVersion);
        } else {
            this.configVersion = null;
            this._visitables.get((Object)"configVersion").remove((Object)this.configVersion);
        }
        return (A)((Object)this);
    }

    public ConfigVersionNested<A> withNewConfigVersion() {
        return new ConfigVersionNested(null);
    }

    public A withNewConfigVersion(String desired) {
        return this.withConfigVersion(new MachineConfigNodeSpecMachineConfigVersion(desired));
    }

    public ConfigVersionNested<A> withNewConfigVersionLike(MachineConfigNodeSpecMachineConfigVersion item) {
        return new ConfigVersionNested(item);
    }

    public NodeNested<A> withNewNode() {
        return new NodeNested(null);
    }

    public A withNewNode(String name) {
        return this.withNode(new MCOObjectReference(name));
    }

    public NodeNested<A> withNewNodeLike(MCOObjectReference item) {
        return new NodeNested(item);
    }

    public PoolNested<A> withNewPool() {
        return new PoolNested(null);
    }

    public A withNewPool(String name) {
        return this.withPool(new MCOObjectReference(name));
    }

    public PoolNested<A> withNewPoolLike(MCOObjectReference item) {
        return new PoolNested(item);
    }

    public A withNode(MCOObjectReference node) {
        this._visitables.remove((Object)"node");
        if (node != null) {
            this.node = new MCOObjectReferenceBuilder(node);
            this._visitables.get((Object)"node").add(this.node);
        } else {
            this.node = null;
            this._visitables.get((Object)"node").remove((Object)this.node);
        }
        return (A)((Object)this);
    }

    public A withPool(MCOObjectReference pool) {
        this._visitables.remove((Object)"pool");
        if (pool != null) {
            this.pool = new MCOObjectReferenceBuilder(pool);
            this._visitables.get((Object)"pool").add(this.pool);
        } else {
            this.pool = null;
            this._visitables.get((Object)"pool").remove((Object)this.pool);
        }
        return (A)((Object)this);
    }

    public class PoolNested<N>
    extends MCOObjectReferenceFluent<PoolNested<N>>
    implements Nested<N> {
        MCOObjectReferenceBuilder builder;

        PoolNested(MCOObjectReference item) {
            this.builder = new MCOObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.withPool(this.builder.build());
        }

        public N endPool() {
            return this.and();
        }
    }

    public class NodeNested<N>
    extends MCOObjectReferenceFluent<NodeNested<N>>
    implements Nested<N> {
        MCOObjectReferenceBuilder builder;

        NodeNested(MCOObjectReference item) {
            this.builder = new MCOObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.withNode(this.builder.build());
        }

        public N endNode() {
            return this.and();
        }
    }

    public class ConfigVersionNested<N>
    extends MachineConfigNodeSpecMachineConfigVersionFluent<ConfigVersionNested<N>>
    implements Nested<N> {
        MachineConfigNodeSpecMachineConfigVersionBuilder builder;

        ConfigVersionNested(MachineConfigNodeSpecMachineConfigVersion item) {
            this.builder = new MachineConfigNodeSpecMachineConfigVersionBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.withConfigVersion(this.builder.build());
        }

        public N endConfigVersion() {
            return this.and();
        }
    }
}

