package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertSpecBuilder extends CertSpecFluent<CertSpecBuilder> implements VisitableBuilder<CertSpec,CertSpecBuilder>{
  public CertSpecBuilder() {
    this(new CertSpec());
  }
  
  public CertSpecBuilder(CertSpecFluent<?> fluent) {
    this(fluent, new CertSpec());
  }
  
  public CertSpecBuilder(CertSpecFluent<?> fluent,CertSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertSpecBuilder(CertSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertSpecFluent<?> fluent;
  
  public CertSpec build() {
    CertSpec buildable = new CertSpec(fluent.getCommonName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}