package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIRequestCountBuilder extends APIRequestCountFluentImpl<APIRequestCountBuilder> implements VisitableBuilder<APIRequestCount,APIRequestCountBuilder>{
  public APIRequestCountBuilder() {
    this(false);
  }
  public APIRequestCountBuilder(Boolean validationEnabled) {
    this(new APIRequestCount(), validationEnabled);
  }
  public APIRequestCountBuilder(APIRequestCountFluent<?> fluent) {
    this(fluent, false);
  }
  public APIRequestCountBuilder(APIRequestCountFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIRequestCount(), validationEnabled);
  }
  public APIRequestCountBuilder(APIRequestCountFluent<?> fluent,APIRequestCount instance) {
    this(fluent, instance, false);
  }
  public APIRequestCountBuilder(APIRequestCountFluent<?> fluent,APIRequestCount instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIRequestCountBuilder(APIRequestCount instance) {
    this(instance,false);
  }
  public APIRequestCountBuilder(APIRequestCount instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  APIRequestCountFluent<?> fluent;
  Boolean validationEnabled;
  public APIRequestCount build() {
    APIRequestCount buildable = new APIRequestCount(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}