package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CredentialsRequestConditionBuilder extends CredentialsRequestConditionFluentImpl<CredentialsRequestConditionBuilder> implements VisitableBuilder<CredentialsRequestCondition,CredentialsRequestConditionBuilder>{
  public CredentialsRequestConditionBuilder() {
    this(false);
  }
  public CredentialsRequestConditionBuilder(Boolean validationEnabled) {
    this(new CredentialsRequestCondition(), validationEnabled);
  }
  public CredentialsRequestConditionBuilder(CredentialsRequestConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public CredentialsRequestConditionBuilder(CredentialsRequestConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CredentialsRequestCondition(), validationEnabled);
  }
  public CredentialsRequestConditionBuilder(CredentialsRequestConditionFluent<?> fluent,CredentialsRequestCondition instance) {
    this(fluent, instance, false);
  }
  public CredentialsRequestConditionBuilder(CredentialsRequestConditionFluent<?> fluent,CredentialsRequestCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastProbeTime(instance.getLastProbeTime()); 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CredentialsRequestConditionBuilder(CredentialsRequestCondition instance) {
    this(instance,false);
  }
  public CredentialsRequestConditionBuilder(CredentialsRequestCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastProbeTime(instance.getLastProbeTime()); 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CredentialsRequestConditionFluent<?> fluent;
  Boolean validationEnabled;
  public CredentialsRequestCondition build() {
    CredentialsRequestCondition buildable = new CredentialsRequestCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}