package io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkAttachmentDefinitionBuilder extends NetworkAttachmentDefinitionFluentImpl<NetworkAttachmentDefinitionBuilder> implements VisitableBuilder<NetworkAttachmentDefinition,NetworkAttachmentDefinitionBuilder>{
  public NetworkAttachmentDefinitionBuilder() {
    this(false);
  }
  public NetworkAttachmentDefinitionBuilder(Boolean validationEnabled) {
    this(new NetworkAttachmentDefinition(), validationEnabled);
  }
  public NetworkAttachmentDefinitionBuilder(NetworkAttachmentDefinitionFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkAttachmentDefinitionBuilder(NetworkAttachmentDefinitionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkAttachmentDefinition(), validationEnabled);
  }
  public NetworkAttachmentDefinitionBuilder(NetworkAttachmentDefinitionFluent<?> fluent,NetworkAttachmentDefinition instance) {
    this(fluent, instance, false);
  }
  public NetworkAttachmentDefinitionBuilder(NetworkAttachmentDefinitionFluent<?> fluent,NetworkAttachmentDefinition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkAttachmentDefinitionBuilder(NetworkAttachmentDefinition instance) {
    this(instance,false);
  }
  public NetworkAttachmentDefinitionBuilder(NetworkAttachmentDefinition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NetworkAttachmentDefinitionFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkAttachmentDefinition build() {
    NetworkAttachmentDefinition buildable = new NetworkAttachmentDefinition(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}