package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistrySpecBuilder extends ImageRegistrySpecFluentImpl<ImageRegistrySpecBuilder> implements VisitableBuilder<ImageRegistrySpec,ImageRegistrySpecBuilder>{
  public ImageRegistrySpecBuilder() {
    this(false);
  }
  public ImageRegistrySpecBuilder(Boolean validationEnabled) {
    this(new ImageRegistrySpec(), validationEnabled);
  }
  public ImageRegistrySpecBuilder(ImageRegistrySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistrySpecBuilder(ImageRegistrySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistrySpec(), validationEnabled);
  }
  public ImageRegistrySpecBuilder(ImageRegistrySpecFluent<?> fluent,ImageRegistrySpec instance) {
    this(fluent, instance, false);
  }
  public ImageRegistrySpecBuilder(ImageRegistrySpecFluent<?> fluent,ImageRegistrySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAffinity(instance.getAffinity()); 
    fluent.withDefaultRoute(instance.getDefaultRoute()); 
    fluent.withDisableRedirect(instance.getDisableRedirect()); 
    fluent.withHttpSecret(instance.getHttpSecret()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withLogging(instance.getLogging()); 
    fluent.withManagementState(instance.getManagementState()); 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withObservedConfig(instance.getObservedConfig()); 
    fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    fluent.withProxy(instance.getProxy()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withRequests(instance.getRequests()); 
    fluent.withResources(instance.getResources()); 
    fluent.withRolloutStrategy(instance.getRolloutStrategy()); 
    fluent.withRoutes(instance.getRoutes()); 
    fluent.withStorage(instance.getStorage()); 
    fluent.withTolerations(instance.getTolerations()); 
    fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistrySpecBuilder(ImageRegistrySpec instance) {
    this(instance,false);
  }
  public ImageRegistrySpecBuilder(ImageRegistrySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAffinity(instance.getAffinity()); 
    this.withDefaultRoute(instance.getDefaultRoute()); 
    this.withDisableRedirect(instance.getDisableRedirect()); 
    this.withHttpSecret(instance.getHttpSecret()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withLogging(instance.getLogging()); 
    this.withManagementState(instance.getManagementState()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withProxy(instance.getProxy()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRequests(instance.getRequests()); 
    this.withResources(instance.getResources()); 
    this.withRolloutStrategy(instance.getRolloutStrategy()); 
    this.withRoutes(instance.getRoutes()); 
    this.withStorage(instance.getStorage()); 
    this.withTolerations(instance.getTolerations()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageRegistrySpecFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistrySpec build() {
    ImageRegistrySpec buildable = new ImageRegistrySpec(fluent.getAffinity(),fluent.getDefaultRoute(),fluent.getDisableRedirect(),fluent.getHttpSecret(),fluent.getLogLevel(),fluent.getLogging(),fluent.getManagementState(),fluent.getNodeSelector(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getProxy(),fluent.getReadOnly(),fluent.getReplicas(),fluent.getRequests(),fluent.getResources(),fluent.getRolloutStrategy(),fluent.getRoutes(),fluent.getStorage(),fluent.getTolerations(),fluent.getUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}