package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomDeployBuilder extends CustomDeployFluentImpl<CustomDeployBuilder> implements VisitableBuilder<CustomDeploy,CustomDeployBuilder>{
  public CustomDeployBuilder() {
    this(false);
  }
  public CustomDeployBuilder(Boolean validationEnabled) {
    this(new CustomDeploy(), validationEnabled);
  }
  public CustomDeployBuilder(CustomDeployFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomDeployBuilder(CustomDeployFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomDeploy(), validationEnabled);
  }
  public CustomDeployBuilder(CustomDeployFluent<?> fluent,CustomDeploy instance) {
    this(fluent, instance, false);
  }
  public CustomDeployBuilder(CustomDeployFluent<?> fluent,CustomDeploy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMethod(instance.getMethod()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomDeployBuilder(CustomDeploy instance) {
    this(instance,false);
  }
  public CustomDeployBuilder(CustomDeploy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMethod(instance.getMethod()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CustomDeployFluent<?> fluent;
  Boolean validationEnabled;
  public CustomDeploy build() {
    CustomDeploy buildable = new CustomDeploy(fluent.getMethod());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}