package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperationMetricBuilder extends OperationMetricFluentImpl<OperationMetricBuilder> implements VisitableBuilder<OperationMetric,OperationMetricBuilder>{
  public OperationMetricBuilder() {
    this(false);
  }
  public OperationMetricBuilder(Boolean validationEnabled) {
    this(new OperationMetric(), validationEnabled);
  }
  public OperationMetricBuilder(OperationMetricFluent<?> fluent) {
    this(fluent, false);
  }
  public OperationMetricBuilder(OperationMetricFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperationMetric(), validationEnabled);
  }
  public OperationMetricBuilder(OperationMetricFluent<?> fluent,OperationMetric instance) {
    this(fluent, instance, false);
  }
  public OperationMetricBuilder(OperationMetricFluent<?> fluent,OperationMetric instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEnd(instance.getEnd()); 
    fluent.withStart(instance.getStart()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperationMetricBuilder(OperationMetric instance) {
    this(instance,false);
  }
  public OperationMetricBuilder(OperationMetric instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEnd(instance.getEnd()); 
    this.withStart(instance.getStart()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperationMetricFluent<?> fluent;
  Boolean validationEnabled;
  public OperationMetric build() {
    OperationMetric buildable = new OperationMetric(fluent.getEnd(),fluent.getStart());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}