package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageBuilder extends StorageFluentImpl<StorageBuilder> implements VisitableBuilder<Storage,StorageBuilder>{
  public StorageBuilder() {
    this(false);
  }
  public StorageBuilder(Boolean validationEnabled) {
    this(new Storage(), validationEnabled);
  }
  public StorageBuilder(StorageFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageBuilder(StorageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Storage(), validationEnabled);
  }
  public StorageBuilder(StorageFluent<?> fluent,Storage instance) {
    this(fluent, instance, false);
  }
  public StorageBuilder(StorageFluent<?> fluent,Storage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHctl(instance.getHctl()); 
    fluent.withModel(instance.getModel()); 
    fluent.withName(instance.getName()); 
    fluent.withRotational(instance.getRotational()); 
    fluent.withSerialNumber(instance.getSerialNumber()); 
    fluent.withSizeBytes(instance.getSizeBytes()); 
    fluent.withType(instance.getType()); 
    fluent.withVendor(instance.getVendor()); 
    fluent.withWwn(instance.getWwn()); 
    fluent.withWwnVendorExtension(instance.getWwnVendorExtension()); 
    fluent.withWwnWithExtension(instance.getWwnWithExtension()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StorageBuilder(Storage instance) {
    this(instance,false);
  }
  public StorageBuilder(Storage instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHctl(instance.getHctl()); 
    this.withModel(instance.getModel()); 
    this.withName(instance.getName()); 
    this.withRotational(instance.getRotational()); 
    this.withSerialNumber(instance.getSerialNumber()); 
    this.withSizeBytes(instance.getSizeBytes()); 
    this.withType(instance.getType()); 
    this.withVendor(instance.getVendor()); 
    this.withWwn(instance.getWwn()); 
    this.withWwnVendorExtension(instance.getWwnVendorExtension()); 
    this.withWwnWithExtension(instance.getWwnWithExtension()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StorageFluent<?> fluent;
  Boolean validationEnabled;
  public Storage build() {
    Storage buildable = new Storage(fluent.getHctl(),fluent.getModel(),fluent.getName(),fluent.getRotational(),fluent.getSerialNumber(),fluent.getSizeBytes(),fluent.getType(),fluent.getVendor(),fluent.getWwn(),fluent.getWwnVendorExtension(),fluent.getWwnWithExtension());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}