package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PerNodeAPIRequestLogBuilder extends PerNodeAPIRequestLogFluentImpl<PerNodeAPIRequestLogBuilder> implements VisitableBuilder<PerNodeAPIRequestLog,PerNodeAPIRequestLogBuilder>{
  public PerNodeAPIRequestLogBuilder() {
    this(false);
  }
  public PerNodeAPIRequestLogBuilder(Boolean validationEnabled) {
    this(new PerNodeAPIRequestLog(), validationEnabled);
  }
  public PerNodeAPIRequestLogBuilder(PerNodeAPIRequestLogFluent<?> fluent) {
    this(fluent, false);
  }
  public PerNodeAPIRequestLogBuilder(PerNodeAPIRequestLogFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PerNodeAPIRequestLog(), validationEnabled);
  }
  public PerNodeAPIRequestLogBuilder(PerNodeAPIRequestLogFluent<?> fluent,PerNodeAPIRequestLog instance) {
    this(fluent, instance, false);
  }
  public PerNodeAPIRequestLogBuilder(PerNodeAPIRequestLogFluent<?> fluent,PerNodeAPIRequestLog instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withByUser(instance.getByUser());
      fluent.withNodeName(instance.getNodeName());
      fluent.withRequestCount(instance.getRequestCount());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PerNodeAPIRequestLogBuilder(PerNodeAPIRequestLog instance) {
    this(instance,false);
  }
  public PerNodeAPIRequestLogBuilder(PerNodeAPIRequestLog instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withByUser(instance.getByUser());
      this.withNodeName(instance.getNodeName());
      this.withRequestCount(instance.getRequestCount());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PerNodeAPIRequestLogFluent<?> fluent;
  Boolean validationEnabled;
  public PerNodeAPIRequestLog build() {
    PerNodeAPIRequestLog buildable = new PerNodeAPIRequestLog(fluent.getByUser(),fluent.getNodeName(),fluent.getRequestCount());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}