package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PerVerbAPIRequestCountBuilder extends PerVerbAPIRequestCountFluentImpl<PerVerbAPIRequestCountBuilder> implements VisitableBuilder<PerVerbAPIRequestCount,PerVerbAPIRequestCountBuilder>{
  public PerVerbAPIRequestCountBuilder() {
    this(false);
  }
  public PerVerbAPIRequestCountBuilder(Boolean validationEnabled) {
    this(new PerVerbAPIRequestCount(), validationEnabled);
  }
  public PerVerbAPIRequestCountBuilder(PerVerbAPIRequestCountFluent<?> fluent) {
    this(fluent, false);
  }
  public PerVerbAPIRequestCountBuilder(PerVerbAPIRequestCountFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PerVerbAPIRequestCount(), validationEnabled);
  }
  public PerVerbAPIRequestCountBuilder(PerVerbAPIRequestCountFluent<?> fluent,PerVerbAPIRequestCount instance) {
    this(fluent, instance, false);
  }
  public PerVerbAPIRequestCountBuilder(PerVerbAPIRequestCountFluent<?> fluent,PerVerbAPIRequestCount instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRequestCount(instance.getRequestCount());
      fluent.withVerb(instance.getVerb());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PerVerbAPIRequestCountBuilder(PerVerbAPIRequestCount instance) {
    this(instance,false);
  }
  public PerVerbAPIRequestCountBuilder(PerVerbAPIRequestCount instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRequestCount(instance.getRequestCount());
      this.withVerb(instance.getVerb());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PerVerbAPIRequestCountFluent<?> fluent;
  Boolean validationEnabled;
  public PerVerbAPIRequestCount build() {
    PerVerbAPIRequestCount buildable = new PerVerbAPIRequestCount(fluent.getRequestCount(),fluent.getVerb());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}