package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CredentialsRequestListBuilder extends CredentialsRequestListFluentImpl<CredentialsRequestListBuilder> implements VisitableBuilder<CredentialsRequestList,CredentialsRequestListBuilder>{
  public CredentialsRequestListBuilder() {
    this(false);
  }
  public CredentialsRequestListBuilder(Boolean validationEnabled) {
    this(new CredentialsRequestList(), validationEnabled);
  }
  public CredentialsRequestListBuilder(CredentialsRequestListFluent<?> fluent) {
    this(fluent, false);
  }
  public CredentialsRequestListBuilder(CredentialsRequestListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CredentialsRequestList(), validationEnabled);
  }
  public CredentialsRequestListBuilder(CredentialsRequestListFluent<?> fluent,CredentialsRequestList instance) {
    this(fluent, instance, false);
  }
  public CredentialsRequestListBuilder(CredentialsRequestListFluent<?> fluent,CredentialsRequestList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CredentialsRequestListBuilder(CredentialsRequestList instance) {
    this(instance,false);
  }
  public CredentialsRequestListBuilder(CredentialsRequestList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CredentialsRequestListFluent<?> fluent;
  Boolean validationEnabled;
  public CredentialsRequestList build() {
    CredentialsRequestList buildable = new CredentialsRequestList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}