package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface CredentialsRequestSpecFluent<A extends CredentialsRequestSpecFluent<A>> extends Fluent<A>{
  public A addToProviderSpec(String key,Object value);
  public A addToProviderSpec(Map<String,Object> map);
  public A removeFromProviderSpec(String key);
  public A removeFromProviderSpec(Map<String,Object> map);
  public Map<String,Object> getProviderSpec();
  public <K,V>A withProviderSpec(Map<String,Object> providerSpec);
  public Boolean hasProviderSpec();
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getSecretRef();
  public ObjectReference buildSecretRef();
  public A withSecretRef(ObjectReference secretRef);
  public Boolean hasSecretRef();
  public CredentialsRequestSpecFluent.SecretRefNested<A> withNewSecretRef();
  public CredentialsRequestSpecFluent.SecretRefNested<A> withNewSecretRefLike(ObjectReference item);
  public CredentialsRequestSpecFluent.SecretRefNested<A> editSecretRef();
  public CredentialsRequestSpecFluent.SecretRefNested<A> editOrNewSecretRef();
  public CredentialsRequestSpecFluent.SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item);
  public A addToServiceAccountNames(int index,String item);
  public A setToServiceAccountNames(int index,String item);
  public A addToServiceAccountNames(java.lang.String... items);
  public A addAllToServiceAccountNames(Collection<String> items);
  public A removeFromServiceAccountNames(java.lang.String... items);
  public A removeAllFromServiceAccountNames(Collection<String> items);
  public List<String> getServiceAccountNames();
  public String getServiceAccountName(int index);
  public String getFirstServiceAccountName();
  public String getLastServiceAccountName();
  public String getMatchingServiceAccountName(Predicate<String> predicate);
  public Boolean hasMatchingServiceAccountName(Predicate<String> predicate);
  public A withServiceAccountNames(List<String> serviceAccountNames);
  public A withServiceAccountNames(java.lang.String... serviceAccountNames);
  public Boolean hasServiceAccountNames();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface SecretRefNested<N> extends Nested<N>,ObjectReferenceFluent<CredentialsRequestSpecFluent.SecretRefNested<N>>{
    public N and();
    public N endSecretRef();
    
  }
  
}