package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CredentialsRequestStatusBuilder extends CredentialsRequestStatusFluentImpl<CredentialsRequestStatusBuilder> implements VisitableBuilder<CredentialsRequestStatus,CredentialsRequestStatusBuilder>{
  public CredentialsRequestStatusBuilder() {
    this(false);
  }
  public CredentialsRequestStatusBuilder(Boolean validationEnabled) {
    this(new CredentialsRequestStatus(), validationEnabled);
  }
  public CredentialsRequestStatusBuilder(CredentialsRequestStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CredentialsRequestStatusBuilder(CredentialsRequestStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CredentialsRequestStatus(), validationEnabled);
  }
  public CredentialsRequestStatusBuilder(CredentialsRequestStatusFluent<?> fluent,CredentialsRequestStatus instance) {
    this(fluent, instance, false);
  }
  public CredentialsRequestStatusBuilder(CredentialsRequestStatusFluent<?> fluent,CredentialsRequestStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withLastSyncCloudCredsSecretResourceVersion(instance.getLastSyncCloudCredsSecretResourceVersion());
      fluent.withLastSyncGeneration(instance.getLastSyncGeneration());
      fluent.withLastSyncTimestamp(instance.getLastSyncTimestamp());
      fluent.withProviderStatus(instance.getProviderStatus());
      fluent.withProvisioned(instance.getProvisioned());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CredentialsRequestStatusBuilder(CredentialsRequestStatus instance) {
    this(instance,false);
  }
  public CredentialsRequestStatusBuilder(CredentialsRequestStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withLastSyncCloudCredsSecretResourceVersion(instance.getLastSyncCloudCredsSecretResourceVersion());
      this.withLastSyncGeneration(instance.getLastSyncGeneration());
      this.withLastSyncTimestamp(instance.getLastSyncTimestamp());
      this.withProviderStatus(instance.getProviderStatus());
      this.withProvisioned(instance.getProvisioned());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CredentialsRequestStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CredentialsRequestStatus build() {
    CredentialsRequestStatus buildable = new CredentialsRequestStatus(fluent.getConditions(),fluent.getLastSyncCloudCredsSecretResourceVersion(),fluent.getLastSyncGeneration(),fluent.getLastSyncTimestamp(),fluent.getProviderStatus(),fluent.getProvisioned());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}