package io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkAttachmentDefinitionSpecBuilder extends NetworkAttachmentDefinitionSpecFluentImpl<NetworkAttachmentDefinitionSpecBuilder> implements VisitableBuilder<NetworkAttachmentDefinitionSpec,NetworkAttachmentDefinitionSpecBuilder>{
  public NetworkAttachmentDefinitionSpecBuilder() {
    this(false);
  }
  public NetworkAttachmentDefinitionSpecBuilder(Boolean validationEnabled) {
    this(new NetworkAttachmentDefinitionSpec(), validationEnabled);
  }
  public NetworkAttachmentDefinitionSpecBuilder(NetworkAttachmentDefinitionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkAttachmentDefinitionSpecBuilder(NetworkAttachmentDefinitionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkAttachmentDefinitionSpec(), validationEnabled);
  }
  public NetworkAttachmentDefinitionSpecBuilder(NetworkAttachmentDefinitionSpecFluent<?> fluent,NetworkAttachmentDefinitionSpec instance) {
    this(fluent, instance, false);
  }
  public NetworkAttachmentDefinitionSpecBuilder(NetworkAttachmentDefinitionSpecFluent<?> fluent,NetworkAttachmentDefinitionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfig(instance.getConfig());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkAttachmentDefinitionSpecBuilder(NetworkAttachmentDefinitionSpec instance) {
    this(instance,false);
  }
  public NetworkAttachmentDefinitionSpecBuilder(NetworkAttachmentDefinitionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfig(instance.getConfig());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkAttachmentDefinitionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkAttachmentDefinitionSpec build() {
    NetworkAttachmentDefinitionSpec buildable = new NetworkAttachmentDefinitionSpec(fluent.getConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}