package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigStorageSwiftBuilder extends ImageRegistryConfigStorageSwiftFluentImpl<ImageRegistryConfigStorageSwiftBuilder> implements VisitableBuilder<ImageRegistryConfigStorageSwift,ImageRegistryConfigStorageSwiftBuilder>{
  public ImageRegistryConfigStorageSwiftBuilder() {
    this(false);
  }
  public ImageRegistryConfigStorageSwiftBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigStorageSwift(), validationEnabled);
  }
  public ImageRegistryConfigStorageSwiftBuilder(ImageRegistryConfigStorageSwiftFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigStorageSwiftBuilder(ImageRegistryConfigStorageSwiftFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigStorageSwift(), validationEnabled);
  }
  public ImageRegistryConfigStorageSwiftBuilder(ImageRegistryConfigStorageSwiftFluent<?> fluent,ImageRegistryConfigStorageSwift instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigStorageSwiftBuilder(ImageRegistryConfigStorageSwiftFluent<?> fluent,ImageRegistryConfigStorageSwift instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAuthURL(instance.getAuthURL());
      fluent.withAuthVersion(instance.getAuthVersion());
      fluent.withContainer(instance.getContainer());
      fluent.withDomain(instance.getDomain());
      fluent.withDomainID(instance.getDomainID());
      fluent.withRegionName(instance.getRegionName());
      fluent.withTenant(instance.getTenant());
      fluent.withTenantID(instance.getTenantID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigStorageSwiftBuilder(ImageRegistryConfigStorageSwift instance) {
    this(instance,false);
  }
  public ImageRegistryConfigStorageSwiftBuilder(ImageRegistryConfigStorageSwift instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAuthURL(instance.getAuthURL());
      this.withAuthVersion(instance.getAuthVersion());
      this.withContainer(instance.getContainer());
      this.withDomain(instance.getDomain());
      this.withDomainID(instance.getDomainID());
      this.withRegionName(instance.getRegionName());
      this.withTenant(instance.getTenant());
      this.withTenantID(instance.getTenantID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigStorageSwiftFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigStorageSwift build() {
    ImageRegistryConfigStorageSwift buildable = new ImageRegistryConfigStorageSwift(fluent.getAuthURL(),fluent.getAuthVersion(),fluent.getContainer(),fluent.getDomain(),fluent.getDomainID(),fluent.getRegionName(),fluent.getTenant(),fluent.getTenantID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}