package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.model.SecretReference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CredentialsStatusFluentImpl<A extends CredentialsStatusFluent<A>> extends BaseFluent<A> implements CredentialsStatusFluent<A>{
  public CredentialsStatusFluentImpl() {
  }
  public CredentialsStatusFluentImpl(CredentialsStatus instance) {
    if (instance != null) {
      this.withCredentials(instance.getCredentials());
      this.withCredentialsVersion(instance.getCredentialsVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private SecretReference credentials;
  private String credentialsVersion;
  private Map<String,Object> additionalProperties;
  public SecretReference getCredentials() {
    return this.credentials;
  }
  public A withCredentials(SecretReference credentials) {
    this.credentials=credentials; return (A) this;
  }
  public Boolean hasCredentials() {
    return this.credentials != null;
  }
  public A withNewCredentials(String name,String namespace) {
    return (A)withCredentials(new SecretReference(name, namespace));
  }
  public String getCredentialsVersion() {
    return this.credentialsVersion;
  }
  public A withCredentialsVersion(String credentialsVersion) {
    this.credentialsVersion=credentialsVersion; return (A) this;
  }
  public Boolean hasCredentialsVersion() {
    return this.credentialsVersion != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CredentialsStatusFluentImpl that = (CredentialsStatusFluentImpl) o;
    if (!java.util.Objects.equals(credentials, that.credentials)) return false;

    if (!java.util.Objects.equals(credentialsVersion, that.credentialsVersion)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(credentials,  credentialsVersion,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (credentials != null) { sb.append("credentials:"); sb.append(credentials + ","); }
    if (credentialsVersion != null) { sb.append("credentialsVersion:"); sb.append(credentialsVersion + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}