package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FirmwareBuilder extends FirmwareFluentImpl<FirmwareBuilder> implements VisitableBuilder<Firmware,FirmwareBuilder>{
  public FirmwareBuilder() {
    this(false);
  }
  public FirmwareBuilder(Boolean validationEnabled) {
    this(new Firmware(), validationEnabled);
  }
  public FirmwareBuilder(FirmwareFluent<?> fluent) {
    this(fluent, false);
  }
  public FirmwareBuilder(FirmwareFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Firmware(), validationEnabled);
  }
  public FirmwareBuilder(FirmwareFluent<?> fluent,Firmware instance) {
    this(fluent, instance, false);
  }
  public FirmwareBuilder(FirmwareFluent<?> fluent,Firmware instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBios(instance.getBios());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FirmwareBuilder(Firmware instance) {
    this(instance,false);
  }
  public FirmwareBuilder(Firmware instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBios(instance.getBios());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FirmwareFluent<?> fluent;
  Boolean validationEnabled;
  public Firmware build() {
    Firmware buildable = new Firmware(fluent.getBios());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}