package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HardwareRAIDVolumeBuilder extends HardwareRAIDVolumeFluentImpl<HardwareRAIDVolumeBuilder> implements VisitableBuilder<HardwareRAIDVolume,HardwareRAIDVolumeBuilder>{
  public HardwareRAIDVolumeBuilder() {
    this(false);
  }
  public HardwareRAIDVolumeBuilder(Boolean validationEnabled) {
    this(new HardwareRAIDVolume(), validationEnabled);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HardwareRAIDVolume(), validationEnabled);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolumeFluent<?> fluent,HardwareRAIDVolume instance) {
    this(fluent, instance, false);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolumeFluent<?> fluent,HardwareRAIDVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLevel(instance.getLevel());
      fluent.withName(instance.getName());
      fluent.withNumberOfPhysicalDisks(instance.getNumberOfPhysicalDisks());
      fluent.withRotational(instance.getRotational());
      fluent.withSizeGibibytes(instance.getSizeGibibytes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolume instance) {
    this(instance,false);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLevel(instance.getLevel());
      this.withName(instance.getName());
      this.withNumberOfPhysicalDisks(instance.getNumberOfPhysicalDisks());
      this.withRotational(instance.getRotational());
      this.withSizeGibibytes(instance.getSizeGibibytes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HardwareRAIDVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public HardwareRAIDVolume build() {
    HardwareRAIDVolume buildable = new HardwareRAIDVolume(fluent.getLevel(),fluent.getName(),fluent.getNumberOfPhysicalDisks(),fluent.getRotational(),fluent.getSizeGibibytes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}