package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RAIDConfigFluentImpl<A extends RAIDConfigFluent<A>> extends BaseFluent<A> implements RAIDConfigFluent<A>{
  public RAIDConfigFluentImpl() {
  }
  public RAIDConfigFluentImpl(RAIDConfig instance) {
    if (instance != null) {
      this.withHardwareRAIDVolumes(instance.getHardwareRAIDVolumes());
      this.withSoftwareRAIDVolumes(instance.getSoftwareRAIDVolumes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<HardwareRAIDVolumeBuilder> hardwareRAIDVolumes = new ArrayList<HardwareRAIDVolumeBuilder>();
  private ArrayList<SoftwareRAIDVolumeBuilder> softwareRAIDVolumes = new ArrayList<SoftwareRAIDVolumeBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToHardwareRAIDVolumes(int index,HardwareRAIDVolume item) {
    if (this.hardwareRAIDVolumes == null) {this.hardwareRAIDVolumes = new ArrayList<HardwareRAIDVolumeBuilder>();}
    HardwareRAIDVolumeBuilder builder = new HardwareRAIDVolumeBuilder(item);
    if (index < 0 || index >= hardwareRAIDVolumes.size()) { _visitables.get("hardwareRAIDVolumes").add(builder); hardwareRAIDVolumes.add(builder); } else { _visitables.get("hardwareRAIDVolumes").add(index, builder); hardwareRAIDVolumes.add(index, builder);}
    return (A)this;
  }
  public A setToHardwareRAIDVolumes(int index,HardwareRAIDVolume item) {
    if (this.hardwareRAIDVolumes == null) {this.hardwareRAIDVolumes = new ArrayList<HardwareRAIDVolumeBuilder>();}
    HardwareRAIDVolumeBuilder builder = new HardwareRAIDVolumeBuilder(item);
    if (index < 0 || index >= hardwareRAIDVolumes.size()) { _visitables.get("hardwareRAIDVolumes").add(builder); hardwareRAIDVolumes.add(builder); } else { _visitables.get("hardwareRAIDVolumes").set(index, builder); hardwareRAIDVolumes.set(index, builder);}
    return (A)this;
  }
  public A addToHardwareRAIDVolumes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareRAIDVolume... items) {
    if (this.hardwareRAIDVolumes == null) {this.hardwareRAIDVolumes = new ArrayList<HardwareRAIDVolumeBuilder>();}
    for (HardwareRAIDVolume item : items) {HardwareRAIDVolumeBuilder builder = new HardwareRAIDVolumeBuilder(item);_visitables.get("hardwareRAIDVolumes").add(builder);this.hardwareRAIDVolumes.add(builder);} return (A)this;
  }
  public A addAllToHardwareRAIDVolumes(Collection<HardwareRAIDVolume> items) {
    if (this.hardwareRAIDVolumes == null) {this.hardwareRAIDVolumes = new ArrayList<HardwareRAIDVolumeBuilder>();}
    for (HardwareRAIDVolume item : items) {HardwareRAIDVolumeBuilder builder = new HardwareRAIDVolumeBuilder(item);_visitables.get("hardwareRAIDVolumes").add(builder);this.hardwareRAIDVolumes.add(builder);} return (A)this;
  }
  public A removeFromHardwareRAIDVolumes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareRAIDVolume... items) {
    for (HardwareRAIDVolume item : items) {HardwareRAIDVolumeBuilder builder = new HardwareRAIDVolumeBuilder(item);_visitables.get("hardwareRAIDVolumes").remove(builder);if (this.hardwareRAIDVolumes != null) {this.hardwareRAIDVolumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromHardwareRAIDVolumes(Collection<HardwareRAIDVolume> items) {
    for (HardwareRAIDVolume item : items) {HardwareRAIDVolumeBuilder builder = new HardwareRAIDVolumeBuilder(item);_visitables.get("hardwareRAIDVolumes").remove(builder);if (this.hardwareRAIDVolumes != null) {this.hardwareRAIDVolumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHardwareRAIDVolumes(Predicate<HardwareRAIDVolumeBuilder> predicate) {
    if (hardwareRAIDVolumes == null) return (A) this;
    final Iterator<HardwareRAIDVolumeBuilder> each = hardwareRAIDVolumes.iterator();
    final List visitables = _visitables.get("hardwareRAIDVolumes");
    while (each.hasNext()) {
      HardwareRAIDVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHardwareRAIDVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HardwareRAIDVolume> getHardwareRAIDVolumes() {
    return hardwareRAIDVolumes != null ? build(hardwareRAIDVolumes) : null;
  }
  public List<HardwareRAIDVolume> buildHardwareRAIDVolumes() {
    return hardwareRAIDVolumes != null ? build(hardwareRAIDVolumes) : null;
  }
  public HardwareRAIDVolume buildHardwareRAIDVolume(int index) {
    return this.hardwareRAIDVolumes.get(index).build();
  }
  public HardwareRAIDVolume buildFirstHardwareRAIDVolume() {
    return this.hardwareRAIDVolumes.get(0).build();
  }
  public HardwareRAIDVolume buildLastHardwareRAIDVolume() {
    return this.hardwareRAIDVolumes.get(hardwareRAIDVolumes.size() - 1).build();
  }
  public HardwareRAIDVolume buildMatchingHardwareRAIDVolume(Predicate<HardwareRAIDVolumeBuilder> predicate) {
    for (HardwareRAIDVolumeBuilder item: hardwareRAIDVolumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHardwareRAIDVolume(Predicate<HardwareRAIDVolumeBuilder> predicate) {
    for (HardwareRAIDVolumeBuilder item: hardwareRAIDVolumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHardwareRAIDVolumes(List<HardwareRAIDVolume> hardwareRAIDVolumes) {
    if (this.hardwareRAIDVolumes != null) { _visitables.get("hardwareRAIDVolumes").clear();}
    if (hardwareRAIDVolumes != null) {this.hardwareRAIDVolumes = new ArrayList(); for (HardwareRAIDVolume item : hardwareRAIDVolumes){this.addToHardwareRAIDVolumes(item);}} else { this.hardwareRAIDVolumes = null;} return (A) this;
  }
  public A withHardwareRAIDVolumes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareRAIDVolume... hardwareRAIDVolumes) {
    if (this.hardwareRAIDVolumes != null) {this.hardwareRAIDVolumes.clear(); _visitables.remove("hardwareRAIDVolumes"); }
    if (hardwareRAIDVolumes != null) {for (HardwareRAIDVolume item :hardwareRAIDVolumes){ this.addToHardwareRAIDVolumes(item);}} return (A) this;
  }
  public Boolean hasHardwareRAIDVolumes() {
    return hardwareRAIDVolumes != null && !hardwareRAIDVolumes.isEmpty();
  }
  public A addNewHardwareRAIDVolume(String level,String name,Integer numberOfPhysicalDisks,Boolean rotational,Integer sizeGibibytes) {
    return (A)addToHardwareRAIDVolumes(new HardwareRAIDVolume(level, name, numberOfPhysicalDisks, rotational, sizeGibibytes));
  }
  public RAIDConfigFluentImpl.HardwareRAIDVolumesNested<A> addNewHardwareRAIDVolume() {
    return new RAIDConfigFluentImpl.HardwareRAIDVolumesNestedImpl();
  }
  public RAIDConfigFluentImpl.HardwareRAIDVolumesNested<A> addNewHardwareRAIDVolumeLike(HardwareRAIDVolume item) {
    return new RAIDConfigFluentImpl.HardwareRAIDVolumesNestedImpl(-1, item);
  }
  public RAIDConfigFluentImpl.HardwareRAIDVolumesNested<A> setNewHardwareRAIDVolumeLike(int index,HardwareRAIDVolume item) {
    return new RAIDConfigFluentImpl.HardwareRAIDVolumesNestedImpl(index, item);
  }
  public RAIDConfigFluentImpl.HardwareRAIDVolumesNested<A> editHardwareRAIDVolume(int index) {
    if (hardwareRAIDVolumes.size() <= index) throw new RuntimeException("Can't edit hardwareRAIDVolumes. Index exceeds size.");
    return setNewHardwareRAIDVolumeLike(index, buildHardwareRAIDVolume(index));
  }
  public RAIDConfigFluentImpl.HardwareRAIDVolumesNested<A> editFirstHardwareRAIDVolume() {
    if (hardwareRAIDVolumes.size() == 0) throw new RuntimeException("Can't edit first hardwareRAIDVolumes. The list is empty.");
    return setNewHardwareRAIDVolumeLike(0, buildHardwareRAIDVolume(0));
  }
  public RAIDConfigFluentImpl.HardwareRAIDVolumesNested<A> editLastHardwareRAIDVolume() {
    int index = hardwareRAIDVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hardwareRAIDVolumes. The list is empty.");
    return setNewHardwareRAIDVolumeLike(index, buildHardwareRAIDVolume(index));
  }
  public RAIDConfigFluentImpl.HardwareRAIDVolumesNested<A> editMatchingHardwareRAIDVolume(Predicate<HardwareRAIDVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hardwareRAIDVolumes.size();i++) { 
    if (predicate.test(hardwareRAIDVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hardwareRAIDVolumes. No match found.");
    return setNewHardwareRAIDVolumeLike(index, buildHardwareRAIDVolume(index));
  }
  public A addToSoftwareRAIDVolumes(int index,SoftwareRAIDVolume item) {
    if (this.softwareRAIDVolumes == null) {this.softwareRAIDVolumes = new ArrayList<SoftwareRAIDVolumeBuilder>();}
    SoftwareRAIDVolumeBuilder builder = new SoftwareRAIDVolumeBuilder(item);
    if (index < 0 || index >= softwareRAIDVolumes.size()) { _visitables.get("softwareRAIDVolumes").add(builder); softwareRAIDVolumes.add(builder); } else { _visitables.get("softwareRAIDVolumes").add(index, builder); softwareRAIDVolumes.add(index, builder);}
    return (A)this;
  }
  public A setToSoftwareRAIDVolumes(int index,SoftwareRAIDVolume item) {
    if (this.softwareRAIDVolumes == null) {this.softwareRAIDVolumes = new ArrayList<SoftwareRAIDVolumeBuilder>();}
    SoftwareRAIDVolumeBuilder builder = new SoftwareRAIDVolumeBuilder(item);
    if (index < 0 || index >= softwareRAIDVolumes.size()) { _visitables.get("softwareRAIDVolumes").add(builder); softwareRAIDVolumes.add(builder); } else { _visitables.get("softwareRAIDVolumes").set(index, builder); softwareRAIDVolumes.set(index, builder);}
    return (A)this;
  }
  public A addToSoftwareRAIDVolumes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SoftwareRAIDVolume... items) {
    if (this.softwareRAIDVolumes == null) {this.softwareRAIDVolumes = new ArrayList<SoftwareRAIDVolumeBuilder>();}
    for (SoftwareRAIDVolume item : items) {SoftwareRAIDVolumeBuilder builder = new SoftwareRAIDVolumeBuilder(item);_visitables.get("softwareRAIDVolumes").add(builder);this.softwareRAIDVolumes.add(builder);} return (A)this;
  }
  public A addAllToSoftwareRAIDVolumes(Collection<SoftwareRAIDVolume> items) {
    if (this.softwareRAIDVolumes == null) {this.softwareRAIDVolumes = new ArrayList<SoftwareRAIDVolumeBuilder>();}
    for (SoftwareRAIDVolume item : items) {SoftwareRAIDVolumeBuilder builder = new SoftwareRAIDVolumeBuilder(item);_visitables.get("softwareRAIDVolumes").add(builder);this.softwareRAIDVolumes.add(builder);} return (A)this;
  }
  public A removeFromSoftwareRAIDVolumes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SoftwareRAIDVolume... items) {
    for (SoftwareRAIDVolume item : items) {SoftwareRAIDVolumeBuilder builder = new SoftwareRAIDVolumeBuilder(item);_visitables.get("softwareRAIDVolumes").remove(builder);if (this.softwareRAIDVolumes != null) {this.softwareRAIDVolumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromSoftwareRAIDVolumes(Collection<SoftwareRAIDVolume> items) {
    for (SoftwareRAIDVolume item : items) {SoftwareRAIDVolumeBuilder builder = new SoftwareRAIDVolumeBuilder(item);_visitables.get("softwareRAIDVolumes").remove(builder);if (this.softwareRAIDVolumes != null) {this.softwareRAIDVolumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSoftwareRAIDVolumes(Predicate<SoftwareRAIDVolumeBuilder> predicate) {
    if (softwareRAIDVolumes == null) return (A) this;
    final Iterator<SoftwareRAIDVolumeBuilder> each = softwareRAIDVolumes.iterator();
    final List visitables = _visitables.get("softwareRAIDVolumes");
    while (each.hasNext()) {
      SoftwareRAIDVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSoftwareRAIDVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SoftwareRAIDVolume> getSoftwareRAIDVolumes() {
    return softwareRAIDVolumes != null ? build(softwareRAIDVolumes) : null;
  }
  public List<SoftwareRAIDVolume> buildSoftwareRAIDVolumes() {
    return softwareRAIDVolumes != null ? build(softwareRAIDVolumes) : null;
  }
  public SoftwareRAIDVolume buildSoftwareRAIDVolume(int index) {
    return this.softwareRAIDVolumes.get(index).build();
  }
  public SoftwareRAIDVolume buildFirstSoftwareRAIDVolume() {
    return this.softwareRAIDVolumes.get(0).build();
  }
  public SoftwareRAIDVolume buildLastSoftwareRAIDVolume() {
    return this.softwareRAIDVolumes.get(softwareRAIDVolumes.size() - 1).build();
  }
  public SoftwareRAIDVolume buildMatchingSoftwareRAIDVolume(Predicate<SoftwareRAIDVolumeBuilder> predicate) {
    for (SoftwareRAIDVolumeBuilder item: softwareRAIDVolumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSoftwareRAIDVolume(Predicate<SoftwareRAIDVolumeBuilder> predicate) {
    for (SoftwareRAIDVolumeBuilder item: softwareRAIDVolumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSoftwareRAIDVolumes(List<SoftwareRAIDVolume> softwareRAIDVolumes) {
    if (this.softwareRAIDVolumes != null) { _visitables.get("softwareRAIDVolumes").clear();}
    if (softwareRAIDVolumes != null) {this.softwareRAIDVolumes = new ArrayList(); for (SoftwareRAIDVolume item : softwareRAIDVolumes){this.addToSoftwareRAIDVolumes(item);}} else { this.softwareRAIDVolumes = null;} return (A) this;
  }
  public A withSoftwareRAIDVolumes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SoftwareRAIDVolume... softwareRAIDVolumes) {
    if (this.softwareRAIDVolumes != null) {this.softwareRAIDVolumes.clear(); _visitables.remove("softwareRAIDVolumes"); }
    if (softwareRAIDVolumes != null) {for (SoftwareRAIDVolume item :softwareRAIDVolumes){ this.addToSoftwareRAIDVolumes(item);}} return (A) this;
  }
  public Boolean hasSoftwareRAIDVolumes() {
    return softwareRAIDVolumes != null && !softwareRAIDVolumes.isEmpty();
  }
  public RAIDConfigFluentImpl.SoftwareRAIDVolumesNested<A> addNewSoftwareRAIDVolume() {
    return new RAIDConfigFluentImpl.SoftwareRAIDVolumesNestedImpl();
  }
  public RAIDConfigFluentImpl.SoftwareRAIDVolumesNested<A> addNewSoftwareRAIDVolumeLike(SoftwareRAIDVolume item) {
    return new RAIDConfigFluentImpl.SoftwareRAIDVolumesNestedImpl(-1, item);
  }
  public RAIDConfigFluentImpl.SoftwareRAIDVolumesNested<A> setNewSoftwareRAIDVolumeLike(int index,SoftwareRAIDVolume item) {
    return new RAIDConfigFluentImpl.SoftwareRAIDVolumesNestedImpl(index, item);
  }
  public RAIDConfigFluentImpl.SoftwareRAIDVolumesNested<A> editSoftwareRAIDVolume(int index) {
    if (softwareRAIDVolumes.size() <= index) throw new RuntimeException("Can't edit softwareRAIDVolumes. Index exceeds size.");
    return setNewSoftwareRAIDVolumeLike(index, buildSoftwareRAIDVolume(index));
  }
  public RAIDConfigFluentImpl.SoftwareRAIDVolumesNested<A> editFirstSoftwareRAIDVolume() {
    if (softwareRAIDVolumes.size() == 0) throw new RuntimeException("Can't edit first softwareRAIDVolumes. The list is empty.");
    return setNewSoftwareRAIDVolumeLike(0, buildSoftwareRAIDVolume(0));
  }
  public RAIDConfigFluentImpl.SoftwareRAIDVolumesNested<A> editLastSoftwareRAIDVolume() {
    int index = softwareRAIDVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last softwareRAIDVolumes. The list is empty.");
    return setNewSoftwareRAIDVolumeLike(index, buildSoftwareRAIDVolume(index));
  }
  public RAIDConfigFluentImpl.SoftwareRAIDVolumesNested<A> editMatchingSoftwareRAIDVolume(Predicate<SoftwareRAIDVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<softwareRAIDVolumes.size();i++) { 
    if (predicate.test(softwareRAIDVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching softwareRAIDVolumes. No match found.");
    return setNewSoftwareRAIDVolumeLike(index, buildSoftwareRAIDVolume(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RAIDConfigFluentImpl that = (RAIDConfigFluentImpl) o;
    if (!java.util.Objects.equals(hardwareRAIDVolumes, that.hardwareRAIDVolumes)) return false;

    if (!java.util.Objects.equals(softwareRAIDVolumes, that.softwareRAIDVolumes)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hardwareRAIDVolumes,  softwareRAIDVolumes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hardwareRAIDVolumes != null) { sb.append("hardwareRAIDVolumes:"); sb.append(hardwareRAIDVolumes + ","); }
    if (softwareRAIDVolumes != null) { sb.append("softwareRAIDVolumes:"); sb.append(softwareRAIDVolumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class HardwareRAIDVolumesNestedImpl<N> extends HardwareRAIDVolumeFluentImpl<RAIDConfigFluentImpl.HardwareRAIDVolumesNested<N>> implements RAIDConfigFluentImpl.HardwareRAIDVolumesNested<N>,Nested<N>{
    HardwareRAIDVolumesNestedImpl(int index,HardwareRAIDVolume item) {
      this.index = index;
      this.builder = new HardwareRAIDVolumeBuilder(this, item);
    }
    HardwareRAIDVolumesNestedImpl() {
      this.index = -1;
      this.builder = new HardwareRAIDVolumeBuilder(this);
    }
    HardwareRAIDVolumeBuilder builder;
    int index;
    public N and() {
      return (N) RAIDConfigFluentImpl.this.setToHardwareRAIDVolumes(index,builder.build());
    }
    public N endHardwareRAIDVolume() {
      return and();
    }
    
  }
  class SoftwareRAIDVolumesNestedImpl<N> extends SoftwareRAIDVolumeFluentImpl<RAIDConfigFluentImpl.SoftwareRAIDVolumesNested<N>> implements RAIDConfigFluentImpl.SoftwareRAIDVolumesNested<N>,Nested<N>{
    SoftwareRAIDVolumesNestedImpl(int index,SoftwareRAIDVolume item) {
      this.index = index;
      this.builder = new SoftwareRAIDVolumeBuilder(this, item);
    }
    SoftwareRAIDVolumesNestedImpl() {
      this.index = -1;
      this.builder = new SoftwareRAIDVolumeBuilder(this);
    }
    SoftwareRAIDVolumeBuilder builder;
    int index;
    public N and() {
      return (N) RAIDConfigFluentImpl.this.setToSoftwareRAIDVolumes(index,builder.build());
    }
    public N endSoftwareRAIDVolume() {
      return and();
    }
    
  }
  
}