package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressRouterStatusConditionBuilder extends EgressRouterStatusConditionFluentImpl<EgressRouterStatusConditionBuilder> implements VisitableBuilder<EgressRouterStatusCondition,EgressRouterStatusConditionBuilder>{
  public EgressRouterStatusConditionBuilder() {
    this(false);
  }
  public EgressRouterStatusConditionBuilder(Boolean validationEnabled) {
    this(new EgressRouterStatusCondition(), validationEnabled);
  }
  public EgressRouterStatusConditionBuilder(EgressRouterStatusConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressRouterStatusConditionBuilder(EgressRouterStatusConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressRouterStatusCondition(), validationEnabled);
  }
  public EgressRouterStatusConditionBuilder(EgressRouterStatusConditionFluent<?> fluent,EgressRouterStatusCondition instance) {
    this(fluent, instance, false);
  }
  public EgressRouterStatusConditionBuilder(EgressRouterStatusConditionFluent<?> fluent,EgressRouterStatusCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressRouterStatusConditionBuilder(EgressRouterStatusCondition instance) {
    this(instance,false);
  }
  public EgressRouterStatusConditionBuilder(EgressRouterStatusCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressRouterStatusConditionFluent<?> fluent;
  Boolean validationEnabled;
  public EgressRouterStatusCondition build() {
    EgressRouterStatusCondition buildable = new EgressRouterStatusCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}