package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MacvlanConfigBuilder extends MacvlanConfigFluentImpl<MacvlanConfigBuilder> implements VisitableBuilder<MacvlanConfig,MacvlanConfigBuilder>{
  public MacvlanConfigBuilder() {
    this(false);
  }
  public MacvlanConfigBuilder(Boolean validationEnabled) {
    this(new MacvlanConfig(), validationEnabled);
  }
  public MacvlanConfigBuilder(MacvlanConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public MacvlanConfigBuilder(MacvlanConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MacvlanConfig(), validationEnabled);
  }
  public MacvlanConfigBuilder(MacvlanConfigFluent<?> fluent,MacvlanConfig instance) {
    this(fluent, instance, false);
  }
  public MacvlanConfigBuilder(MacvlanConfigFluent<?> fluent,MacvlanConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMaster(instance.getMaster());
      fluent.withMode(instance.getMode());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MacvlanConfigBuilder(MacvlanConfig instance) {
    this(instance,false);
  }
  public MacvlanConfigBuilder(MacvlanConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMaster(instance.getMaster());
      this.withMode(instance.getMode());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MacvlanConfigFluent<?> fluent;
  Boolean validationEnabled;
  public MacvlanConfig build() {
    MacvlanConfig buildable = new MacvlanConfig(fluent.getMaster(),fluent.getMode());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}