package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorPKIBuilder extends OperatorPKIFluentImpl<OperatorPKIBuilder> implements VisitableBuilder<OperatorPKI,OperatorPKIBuilder>{
  public OperatorPKIBuilder() {
    this(false);
  }
  public OperatorPKIBuilder(Boolean validationEnabled) {
    this(new OperatorPKI(), validationEnabled);
  }
  public OperatorPKIBuilder(OperatorPKIFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorPKIBuilder(OperatorPKIFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorPKI(), validationEnabled);
  }
  public OperatorPKIBuilder(OperatorPKIFluent<?> fluent,OperatorPKI instance) {
    this(fluent, instance, false);
  }
  public OperatorPKIBuilder(OperatorPKIFluent<?> fluent,OperatorPKI instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorPKIBuilder(OperatorPKI instance) {
    this(instance,false);
  }
  public OperatorPKIBuilder(OperatorPKI instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorPKIFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorPKI build() {
    OperatorPKI buildable = new OperatorPKI(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}