package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OperatorPKIListFluentImpl<A extends OperatorPKIListFluent<A>> extends BaseFluent<A> implements OperatorPKIListFluent<A>{
  public OperatorPKIListFluentImpl() {
  }
  public OperatorPKIListFluentImpl(OperatorPKIList instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private ArrayList<OperatorPKIBuilder> items = new ArrayList<OperatorPKIBuilder>();
  private String kind;
  private ListMeta metadata;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(int index,OperatorPKI item) {
    if (this.items == null) {this.items = new ArrayList<OperatorPKIBuilder>();}
    OperatorPKIBuilder builder = new OperatorPKIBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToItems(int index,OperatorPKI item) {
    if (this.items == null) {this.items = new ArrayList<OperatorPKIBuilder>();}
    OperatorPKIBuilder builder = new OperatorPKIBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToItems(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKI... items) {
    if (this.items == null) {this.items = new ArrayList<OperatorPKIBuilder>();}
    for (OperatorPKI item : items) {OperatorPKIBuilder builder = new OperatorPKIBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<OperatorPKI> items) {
    if (this.items == null) {this.items = new ArrayList<OperatorPKIBuilder>();}
    for (OperatorPKI item : items) {OperatorPKIBuilder builder = new OperatorPKIBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKI... items) {
    for (OperatorPKI item : items) {OperatorPKIBuilder builder = new OperatorPKIBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<OperatorPKI> items) {
    for (OperatorPKI item : items) {OperatorPKIBuilder builder = new OperatorPKIBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<OperatorPKIBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<OperatorPKIBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      OperatorPKIBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OperatorPKI> getItems() {
    return items != null ? build(items) : null;
  }
  public List<OperatorPKI> buildItems() {
    return items != null ? build(items) : null;
  }
  public OperatorPKI buildItem(int index) {
    return this.items.get(index).build();
  }
  public OperatorPKI buildFirstItem() {
    return this.items.get(0).build();
  }
  public OperatorPKI buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public OperatorPKI buildMatchingItem(Predicate<OperatorPKIBuilder> predicate) {
    for (OperatorPKIBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<OperatorPKIBuilder> predicate) {
    for (OperatorPKIBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<OperatorPKI> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (OperatorPKI item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKI... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (OperatorPKI item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public OperatorPKIListFluentImpl.ItemsNested<A> addNewItem() {
    return new OperatorPKIListFluentImpl.ItemsNestedImpl();
  }
  public OperatorPKIListFluentImpl.ItemsNested<A> addNewItemLike(OperatorPKI item) {
    return new OperatorPKIListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public OperatorPKIListFluentImpl.ItemsNested<A> setNewItemLike(int index,OperatorPKI item) {
    return new OperatorPKIListFluentImpl.ItemsNestedImpl(index, item);
  }
  public OperatorPKIListFluentImpl.ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public OperatorPKIListFluentImpl.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public OperatorPKIListFluentImpl.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public OperatorPKIListFluentImpl.ItemsNested<A> editMatchingItem(Predicate<OperatorPKIBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OperatorPKIListFluentImpl that = (OperatorPKIListFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends OperatorPKIFluentImpl<OperatorPKIListFluentImpl.ItemsNested<N>> implements OperatorPKIListFluentImpl.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(int index,OperatorPKI item) {
      this.index = index;
      this.builder = new OperatorPKIBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new OperatorPKIBuilder(this);
    }
    OperatorPKIBuilder builder;
    int index;
    public N and() {
      return (N) OperatorPKIListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}