package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureProviderSpecFluent<A extends AzureProviderSpecFluent<A>> extends BaseFluent<A>{
  public AzureProviderSpecFluent() {
  }
  
  public AzureProviderSpecFluent(AzureProviderSpec instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String azureClientID;
  private String azureRegion;
  private String azureSubscriptionID;
  private String azureTenantID;
  private List<String> dataPermissions = new ArrayList<String>();
  private String kind;
  private List<String> permissions = new ArrayList<String>();
  private ArrayList<RoleBindingBuilder> roleBindings = new ArrayList<RoleBindingBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AzureProviderSpec instance) {
    instance = (instance != null ? instance : new AzureProviderSpec());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withAzureClientID(instance.getAzureClientID());
          this.withAzureRegion(instance.getAzureRegion());
          this.withAzureSubscriptionID(instance.getAzureSubscriptionID());
          this.withAzureTenantID(instance.getAzureTenantID());
          this.withDataPermissions(instance.getDataPermissions());
          this.withKind(instance.getKind());
          this.withPermissions(instance.getPermissions());
          this.withRoleBindings(instance.getRoleBindings());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getAzureClientID() {
    return this.azureClientID;
  }
  
  public A withAzureClientID(String azureClientID) {
    this.azureClientID = azureClientID;
    return (A) this;
  }
  
  public boolean hasAzureClientID() {
    return this.azureClientID != null;
  }
  
  public String getAzureRegion() {
    return this.azureRegion;
  }
  
  public A withAzureRegion(String azureRegion) {
    this.azureRegion = azureRegion;
    return (A) this;
  }
  
  public boolean hasAzureRegion() {
    return this.azureRegion != null;
  }
  
  public String getAzureSubscriptionID() {
    return this.azureSubscriptionID;
  }
  
  public A withAzureSubscriptionID(String azureSubscriptionID) {
    this.azureSubscriptionID = azureSubscriptionID;
    return (A) this;
  }
  
  public boolean hasAzureSubscriptionID() {
    return this.azureSubscriptionID != null;
  }
  
  public String getAzureTenantID() {
    return this.azureTenantID;
  }
  
  public A withAzureTenantID(String azureTenantID) {
    this.azureTenantID = azureTenantID;
    return (A) this;
  }
  
  public boolean hasAzureTenantID() {
    return this.azureTenantID != null;
  }
  
  public A addToDataPermissions(int index,String item) {
    if (this.dataPermissions == null) {this.dataPermissions = new ArrayList<String>();}
    this.dataPermissions.add(index, item);
    return (A)this;
  }
  
  public A setToDataPermissions(int index,String item) {
    if (this.dataPermissions == null) {this.dataPermissions = new ArrayList<String>();}
    this.dataPermissions.set(index, item); return (A)this;
  }
  
  public A addToDataPermissions(java.lang.String... items) {
    if (this.dataPermissions == null) {this.dataPermissions = new ArrayList<String>();}
    for (String item : items) {this.dataPermissions.add(item);} return (A)this;
  }
  
  public A addAllToDataPermissions(Collection<String> items) {
    if (this.dataPermissions == null) {this.dataPermissions = new ArrayList<String>();}
    for (String item : items) {this.dataPermissions.add(item);} return (A)this;
  }
  
  public A removeFromDataPermissions(java.lang.String... items) {
    if (this.dataPermissions == null) return (A)this;
    for (String item : items) { this.dataPermissions.remove(item);} return (A)this;
  }
  
  public A removeAllFromDataPermissions(Collection<String> items) {
    if (this.dataPermissions == null) return (A)this;
    for (String item : items) { this.dataPermissions.remove(item);} return (A)this;
  }
  
  public List<String> getDataPermissions() {
    return this.dataPermissions;
  }
  
  public String getDataPermission(int index) {
    return this.dataPermissions.get(index);
  }
  
  public String getFirstDataPermission() {
    return this.dataPermissions.get(0);
  }
  
  public String getLastDataPermission() {
    return this.dataPermissions.get(dataPermissions.size() - 1);
  }
  
  public String getMatchingDataPermission(Predicate<String> predicate) {
      for (String item : dataPermissions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingDataPermission(Predicate<String> predicate) {
      for (String item : dataPermissions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDataPermissions(List<String> dataPermissions) {
    if (dataPermissions != null) {
        this.dataPermissions = new ArrayList();
        for (String item : dataPermissions) {
          this.addToDataPermissions(item);
        }
    } else {
      this.dataPermissions = null;
    }
    return (A) this;
  }
  
  public A withDataPermissions(java.lang.String... dataPermissions) {
    if (this.dataPermissions != null) {
        this.dataPermissions.clear();
        _visitables.remove("dataPermissions");
    }
    if (dataPermissions != null) {
      for (String item : dataPermissions) {
        this.addToDataPermissions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDataPermissions() {
    return this.dataPermissions != null && !this.dataPermissions.isEmpty();
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public A addToPermissions(int index,String item) {
    if (this.permissions == null) {this.permissions = new ArrayList<String>();}
    this.permissions.add(index, item);
    return (A)this;
  }
  
  public A setToPermissions(int index,String item) {
    if (this.permissions == null) {this.permissions = new ArrayList<String>();}
    this.permissions.set(index, item); return (A)this;
  }
  
  public A addToPermissions(java.lang.String... items) {
    if (this.permissions == null) {this.permissions = new ArrayList<String>();}
    for (String item : items) {this.permissions.add(item);} return (A)this;
  }
  
  public A addAllToPermissions(Collection<String> items) {
    if (this.permissions == null) {this.permissions = new ArrayList<String>();}
    for (String item : items) {this.permissions.add(item);} return (A)this;
  }
  
  public A removeFromPermissions(java.lang.String... items) {
    if (this.permissions == null) return (A)this;
    for (String item : items) { this.permissions.remove(item);} return (A)this;
  }
  
  public A removeAllFromPermissions(Collection<String> items) {
    if (this.permissions == null) return (A)this;
    for (String item : items) { this.permissions.remove(item);} return (A)this;
  }
  
  public List<String> getPermissions() {
    return this.permissions;
  }
  
  public String getPermission(int index) {
    return this.permissions.get(index);
  }
  
  public String getFirstPermission() {
    return this.permissions.get(0);
  }
  
  public String getLastPermission() {
    return this.permissions.get(permissions.size() - 1);
  }
  
  public String getMatchingPermission(Predicate<String> predicate) {
      for (String item : permissions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingPermission(Predicate<String> predicate) {
      for (String item : permissions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPermissions(List<String> permissions) {
    if (permissions != null) {
        this.permissions = new ArrayList();
        for (String item : permissions) {
          this.addToPermissions(item);
        }
    } else {
      this.permissions = null;
    }
    return (A) this;
  }
  
  public A withPermissions(java.lang.String... permissions) {
    if (this.permissions != null) {
        this.permissions.clear();
        _visitables.remove("permissions");
    }
    if (permissions != null) {
      for (String item : permissions) {
        this.addToPermissions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPermissions() {
    return this.permissions != null && !this.permissions.isEmpty();
  }
  
  public A addToRoleBindings(int index,RoleBinding item) {
    if (this.roleBindings == null) {this.roleBindings = new ArrayList<RoleBindingBuilder>();}
    RoleBindingBuilder builder = new RoleBindingBuilder(item);
    if (index < 0 || index >= roleBindings.size()) { _visitables.get("roleBindings").add(builder); roleBindings.add(builder); } else { _visitables.get("roleBindings").add(index, builder); roleBindings.add(index, builder);}
    return (A)this;
  }
  
  public A setToRoleBindings(int index,RoleBinding item) {
    if (this.roleBindings == null) {this.roleBindings = new ArrayList<RoleBindingBuilder>();}
    RoleBindingBuilder builder = new RoleBindingBuilder(item);
    if (index < 0 || index >= roleBindings.size()) { _visitables.get("roleBindings").add(builder); roleBindings.add(builder); } else { _visitables.get("roleBindings").set(index, builder); roleBindings.set(index, builder);}
    return (A)this;
  }
  
  public A addToRoleBindings(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.RoleBinding... items) {
    if (this.roleBindings == null) {this.roleBindings = new ArrayList<RoleBindingBuilder>();}
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("roleBindings").add(builder);this.roleBindings.add(builder);} return (A)this;
  }
  
  public A addAllToRoleBindings(Collection<RoleBinding> items) {
    if (this.roleBindings == null) {this.roleBindings = new ArrayList<RoleBindingBuilder>();}
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("roleBindings").add(builder);this.roleBindings.add(builder);} return (A)this;
  }
  
  public A removeFromRoleBindings(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.RoleBinding... items) {
    if (this.roleBindings == null) return (A)this;
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("roleBindings").remove(builder); this.roleBindings.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRoleBindings(Collection<RoleBinding> items) {
    if (this.roleBindings == null) return (A)this;
    for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.get("roleBindings").remove(builder); this.roleBindings.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRoleBindings(Predicate<RoleBindingBuilder> predicate) {
    if (roleBindings == null) return (A) this;
    final Iterator<RoleBindingBuilder> each = roleBindings.iterator();
    final List visitables = _visitables.get("roleBindings");
    while (each.hasNext()) {
      RoleBindingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RoleBinding> buildRoleBindings() {
    return this.roleBindings != null ? build(roleBindings) : null;
  }
  
  public RoleBinding buildRoleBinding(int index) {
    return this.roleBindings.get(index).build();
  }
  
  public RoleBinding buildFirstRoleBinding() {
    return this.roleBindings.get(0).build();
  }
  
  public RoleBinding buildLastRoleBinding() {
    return this.roleBindings.get(roleBindings.size() - 1).build();
  }
  
  public RoleBinding buildMatchingRoleBinding(Predicate<RoleBindingBuilder> predicate) {
      for (RoleBindingBuilder item : roleBindings) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRoleBinding(Predicate<RoleBindingBuilder> predicate) {
      for (RoleBindingBuilder item : roleBindings) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRoleBindings(List<RoleBinding> roleBindings) {
    if (this.roleBindings != null) {
      this._visitables.get("roleBindings").clear();
    }
    if (roleBindings != null) {
        this.roleBindings = new ArrayList();
        for (RoleBinding item : roleBindings) {
          this.addToRoleBindings(item);
        }
    } else {
      this.roleBindings = null;
    }
    return (A) this;
  }
  
  public A withRoleBindings(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.RoleBinding... roleBindings) {
    if (this.roleBindings != null) {
        this.roleBindings.clear();
        _visitables.remove("roleBindings");
    }
    if (roleBindings != null) {
      for (RoleBinding item : roleBindings) {
        this.addToRoleBindings(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRoleBindings() {
    return this.roleBindings != null && !this.roleBindings.isEmpty();
  }
  
  public A addNewRoleBinding(String role) {
    return (A)addToRoleBindings(new RoleBinding(role));
  }
  
  public RoleBindingsNested<A> addNewRoleBinding() {
    return new RoleBindingsNested(-1, null);
  }
  
  public RoleBindingsNested<A> addNewRoleBindingLike(RoleBinding item) {
    return new RoleBindingsNested(-1, item);
  }
  
  public RoleBindingsNested<A> setNewRoleBindingLike(int index,RoleBinding item) {
    return new RoleBindingsNested(index, item);
  }
  
  public RoleBindingsNested<A> editRoleBinding(int index) {
    if (roleBindings.size() <= index) throw new RuntimeException("Can't edit roleBindings. Index exceeds size.");
    return setNewRoleBindingLike(index, buildRoleBinding(index));
  }
  
  public RoleBindingsNested<A> editFirstRoleBinding() {
    if (roleBindings.size() == 0) throw new RuntimeException("Can't edit first roleBindings. The list is empty.");
    return setNewRoleBindingLike(0, buildRoleBinding(0));
  }
  
  public RoleBindingsNested<A> editLastRoleBinding() {
    int index = roleBindings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last roleBindings. The list is empty.");
    return setNewRoleBindingLike(index, buildRoleBinding(index));
  }
  
  public RoleBindingsNested<A> editMatchingRoleBinding(Predicate<RoleBindingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<roleBindings.size();i++) { 
    if (predicate.test(roleBindings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching roleBindings. No match found.");
    return setNewRoleBindingLike(index, buildRoleBinding(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureProviderSpecFluent that = (AzureProviderSpecFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(azureClientID, that.azureClientID)) return false;
    if (!java.util.Objects.equals(azureRegion, that.azureRegion)) return false;
    if (!java.util.Objects.equals(azureSubscriptionID, that.azureSubscriptionID)) return false;
    if (!java.util.Objects.equals(azureTenantID, that.azureTenantID)) return false;
    if (!java.util.Objects.equals(dataPermissions, that.dataPermissions)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(permissions, that.permissions)) return false;
    if (!java.util.Objects.equals(roleBindings, that.roleBindings)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  azureClientID,  azureRegion,  azureSubscriptionID,  azureTenantID,  dataPermissions,  kind,  permissions,  roleBindings,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (azureClientID != null) { sb.append("azureClientID:"); sb.append(azureClientID + ","); }
    if (azureRegion != null) { sb.append("azureRegion:"); sb.append(azureRegion + ","); }
    if (azureSubscriptionID != null) { sb.append("azureSubscriptionID:"); sb.append(azureSubscriptionID + ","); }
    if (azureTenantID != null) { sb.append("azureTenantID:"); sb.append(azureTenantID + ","); }
    if (dataPermissions != null && !dataPermissions.isEmpty()) { sb.append("dataPermissions:"); sb.append(dataPermissions + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (permissions != null && !permissions.isEmpty()) { sb.append("permissions:"); sb.append(permissions + ","); }
    if (roleBindings != null && !roleBindings.isEmpty()) { sb.append("roleBindings:"); sb.append(roleBindings + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RoleBindingsNested<N> extends RoleBindingFluent<RoleBindingsNested<N>> implements Nested<N>{
    RoleBindingsNested(int index,RoleBinding item) {
      this.index = index;
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingBuilder builder;
    int index;
    
    public N and() {
      return (N) AzureProviderSpecFluent.this.setToRoleBindings(index,builder.build());
    }
    
    public N endRoleBinding() {
      return and();
    }
    
  
  }

}