package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IBMCloudProviderSpecFluent<A extends IBMCloudProviderSpecFluent<A>> extends BaseFluent<A>{
  public IBMCloudProviderSpecFluent() {
  }
  
  public IBMCloudProviderSpecFluent(IBMCloudProviderSpec instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String kind;
  private ArrayList<AccessPolicyBuilder> policies = new ArrayList<AccessPolicyBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IBMCloudProviderSpec instance) {
    instance = (instance != null ? instance : new IBMCloudProviderSpec());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withKind(instance.getKind());
          this.withPolicies(instance.getPolicies());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public A addToPolicies(int index,AccessPolicy item) {
    if (this.policies == null) {this.policies = new ArrayList<AccessPolicyBuilder>();}
    AccessPolicyBuilder builder = new AccessPolicyBuilder(item);
    if (index < 0 || index >= policies.size()) { _visitables.get("policies").add(builder); policies.add(builder); } else { _visitables.get("policies").add(index, builder); policies.add(index, builder);}
    return (A)this;
  }
  
  public A setToPolicies(int index,AccessPolicy item) {
    if (this.policies == null) {this.policies = new ArrayList<AccessPolicyBuilder>();}
    AccessPolicyBuilder builder = new AccessPolicyBuilder(item);
    if (index < 0 || index >= policies.size()) { _visitables.get("policies").add(builder); policies.add(builder); } else { _visitables.get("policies").set(index, builder); policies.set(index, builder);}
    return (A)this;
  }
  
  public A addToPolicies(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.AccessPolicy... items) {
    if (this.policies == null) {this.policies = new ArrayList<AccessPolicyBuilder>();}
    for (AccessPolicy item : items) {AccessPolicyBuilder builder = new AccessPolicyBuilder(item);_visitables.get("policies").add(builder);this.policies.add(builder);} return (A)this;
  }
  
  public A addAllToPolicies(Collection<AccessPolicy> items) {
    if (this.policies == null) {this.policies = new ArrayList<AccessPolicyBuilder>();}
    for (AccessPolicy item : items) {AccessPolicyBuilder builder = new AccessPolicyBuilder(item);_visitables.get("policies").add(builder);this.policies.add(builder);} return (A)this;
  }
  
  public A removeFromPolicies(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.AccessPolicy... items) {
    if (this.policies == null) return (A)this;
    for (AccessPolicy item : items) {AccessPolicyBuilder builder = new AccessPolicyBuilder(item);_visitables.get("policies").remove(builder); this.policies.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPolicies(Collection<AccessPolicy> items) {
    if (this.policies == null) return (A)this;
    for (AccessPolicy item : items) {AccessPolicyBuilder builder = new AccessPolicyBuilder(item);_visitables.get("policies").remove(builder); this.policies.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPolicies(Predicate<AccessPolicyBuilder> predicate) {
    if (policies == null) return (A) this;
    final Iterator<AccessPolicyBuilder> each = policies.iterator();
    final List visitables = _visitables.get("policies");
    while (each.hasNext()) {
      AccessPolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AccessPolicy> buildPolicies() {
    return this.policies != null ? build(policies) : null;
  }
  
  public AccessPolicy buildPolicy(int index) {
    return this.policies.get(index).build();
  }
  
  public AccessPolicy buildFirstPolicy() {
    return this.policies.get(0).build();
  }
  
  public AccessPolicy buildLastPolicy() {
    return this.policies.get(policies.size() - 1).build();
  }
  
  public AccessPolicy buildMatchingPolicy(Predicate<AccessPolicyBuilder> predicate) {
      for (AccessPolicyBuilder item : policies) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPolicy(Predicate<AccessPolicyBuilder> predicate) {
      for (AccessPolicyBuilder item : policies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPolicies(List<AccessPolicy> policies) {
    if (this.policies != null) {
      this._visitables.get("policies").clear();
    }
    if (policies != null) {
        this.policies = new ArrayList();
        for (AccessPolicy item : policies) {
          this.addToPolicies(item);
        }
    } else {
      this.policies = null;
    }
    return (A) this;
  }
  
  public A withPolicies(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.AccessPolicy... policies) {
    if (this.policies != null) {
        this.policies.clear();
        _visitables.remove("policies");
    }
    if (policies != null) {
      for (AccessPolicy item : policies) {
        this.addToPolicies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPolicies() {
    return this.policies != null && !this.policies.isEmpty();
  }
  
  public PoliciesNested<A> addNewPolicy() {
    return new PoliciesNested(-1, null);
  }
  
  public PoliciesNested<A> addNewPolicyLike(AccessPolicy item) {
    return new PoliciesNested(-1, item);
  }
  
  public PoliciesNested<A> setNewPolicyLike(int index,AccessPolicy item) {
    return new PoliciesNested(index, item);
  }
  
  public PoliciesNested<A> editPolicy(int index) {
    if (policies.size() <= index) throw new RuntimeException("Can't edit policies. Index exceeds size.");
    return setNewPolicyLike(index, buildPolicy(index));
  }
  
  public PoliciesNested<A> editFirstPolicy() {
    if (policies.size() == 0) throw new RuntimeException("Can't edit first policies. The list is empty.");
    return setNewPolicyLike(0, buildPolicy(0));
  }
  
  public PoliciesNested<A> editLastPolicy() {
    int index = policies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last policies. The list is empty.");
    return setNewPolicyLike(index, buildPolicy(index));
  }
  
  public PoliciesNested<A> editMatchingPolicy(Predicate<AccessPolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<policies.size();i++) { 
    if (predicate.test(policies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching policies. No match found.");
    return setNewPolicyLike(index, buildPolicy(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IBMCloudProviderSpecFluent that = (IBMCloudProviderSpecFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(policies, that.policies)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  policies,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (policies != null && !policies.isEmpty()) { sb.append("policies:"); sb.append(policies + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PoliciesNested<N> extends AccessPolicyFluent<PoliciesNested<N>> implements Nested<N>{
    PoliciesNested(int index,AccessPolicy item) {
      this.index = index;
      this.builder = new AccessPolicyBuilder(this, item);
    }
    AccessPolicyBuilder builder;
    int index;
    
    public N and() {
      return (N) IBMCloudProviderSpecFluent.this.setToPolicies(index,builder.build());
    }
    
    public N endPolicy() {
      return and();
    }
    
  
  }

}