package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StatementEntryBuilder extends StatementEntryFluent<StatementEntryBuilder> implements VisitableBuilder<StatementEntry,StatementEntryBuilder>{
  public StatementEntryBuilder() {
    this(new StatementEntry());
  }
  
  public StatementEntryBuilder(StatementEntryFluent<?> fluent) {
    this(fluent, new StatementEntry());
  }
  
  public StatementEntryBuilder(StatementEntryFluent<?> fluent,StatementEntry instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StatementEntryBuilder(StatementEntry instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StatementEntryFluent<?> fluent;
  
  public StatementEntry build() {
    StatementEntry buildable = new StatementEntry(fluent.getAction(),fluent.getEffect(),fluent.getPolicyCondition(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}