package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.model.Condition;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PreprovisioningImageStatusFluent<A extends PreprovisioningImageStatusFluent<A>> extends BaseFluent<A>{
  public PreprovisioningImageStatusFluent() {
  }
  
  public PreprovisioningImageStatusFluent(PreprovisioningImageStatus instance) {
    this.copyInstance(instance);
  }
  private String architecture;
  private List<Condition> conditions = new ArrayList<Condition>();
  private String extraKernelParams;
  private String format;
  private String imageUrl;
  private String kernelUrl;
  private SecretStatusBuilder networkData;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PreprovisioningImageStatus instance) {
    instance = (instance != null ? instance : new PreprovisioningImageStatus());
    if (instance != null) {
          this.withArchitecture(instance.getArchitecture());
          this.withConditions(instance.getConditions());
          this.withExtraKernelParams(instance.getExtraKernelParams());
          this.withFormat(instance.getFormat());
          this.withImageUrl(instance.getImageUrl());
          this.withKernelUrl(instance.getKernelUrl());
          this.withNetworkData(instance.getNetworkData());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getArchitecture() {
    return this.architecture;
  }
  
  public A withArchitecture(String architecture) {
    this.architecture = architecture;
    return (A) this;
  }
  
  public boolean hasArchitecture() {
    return this.architecture != null;
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public String getExtraKernelParams() {
    return this.extraKernelParams;
  }
  
  public A withExtraKernelParams(String extraKernelParams) {
    this.extraKernelParams = extraKernelParams;
    return (A) this;
  }
  
  public boolean hasExtraKernelParams() {
    return this.extraKernelParams != null;
  }
  
  public String getFormat() {
    return this.format;
  }
  
  public A withFormat(String format) {
    this.format = format;
    return (A) this;
  }
  
  public boolean hasFormat() {
    return this.format != null;
  }
  
  public String getImageUrl() {
    return this.imageUrl;
  }
  
  public A withImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
    return (A) this;
  }
  
  public boolean hasImageUrl() {
    return this.imageUrl != null;
  }
  
  public String getKernelUrl() {
    return this.kernelUrl;
  }
  
  public A withKernelUrl(String kernelUrl) {
    this.kernelUrl = kernelUrl;
    return (A) this;
  }
  
  public boolean hasKernelUrl() {
    return this.kernelUrl != null;
  }
  
  public SecretStatus buildNetworkData() {
    return this.networkData != null ? this.networkData.build() : null;
  }
  
  public A withNetworkData(SecretStatus networkData) {
    this._visitables.remove("networkData");
    if (networkData != null) {
        this.networkData = new SecretStatusBuilder(networkData);
        this._visitables.get("networkData").add(this.networkData);
    } else {
        this.networkData = null;
        this._visitables.get("networkData").remove(this.networkData);
    }
    return (A) this;
  }
  
  public boolean hasNetworkData() {
    return this.networkData != null;
  }
  
  public A withNewNetworkData(String name,String version) {
    return (A)withNetworkData(new SecretStatus(name, version));
  }
  
  public NetworkDataNested<A> withNewNetworkData() {
    return new NetworkDataNested(null);
  }
  
  public NetworkDataNested<A> withNewNetworkDataLike(SecretStatus item) {
    return new NetworkDataNested(item);
  }
  
  public NetworkDataNested<A> editNetworkData() {
    return withNewNetworkDataLike(java.util.Optional.ofNullable(buildNetworkData()).orElse(null));
  }
  
  public NetworkDataNested<A> editOrNewNetworkData() {
    return withNewNetworkDataLike(java.util.Optional.ofNullable(buildNetworkData()).orElse(new SecretStatusBuilder().build()));
  }
  
  public NetworkDataNested<A> editOrNewNetworkDataLike(SecretStatus item) {
    return withNewNetworkDataLike(java.util.Optional.ofNullable(buildNetworkData()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PreprovisioningImageStatusFluent that = (PreprovisioningImageStatusFluent) o;
    if (!java.util.Objects.equals(architecture, that.architecture)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(extraKernelParams, that.extraKernelParams)) return false;
    if (!java.util.Objects.equals(format, that.format)) return false;
    if (!java.util.Objects.equals(imageUrl, that.imageUrl)) return false;
    if (!java.util.Objects.equals(kernelUrl, that.kernelUrl)) return false;
    if (!java.util.Objects.equals(networkData, that.networkData)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(architecture,  conditions,  extraKernelParams,  format,  imageUrl,  kernelUrl,  networkData,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (architecture != null) { sb.append("architecture:"); sb.append(architecture + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (extraKernelParams != null) { sb.append("extraKernelParams:"); sb.append(extraKernelParams + ","); }
    if (format != null) { sb.append("format:"); sb.append(format + ","); }
    if (imageUrl != null) { sb.append("imageUrl:"); sb.append(imageUrl + ","); }
    if (kernelUrl != null) { sb.append("kernelUrl:"); sb.append(kernelUrl + ","); }
    if (networkData != null) { sb.append("networkData:"); sb.append(networkData + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class NetworkDataNested<N> extends SecretStatusFluent<NetworkDataNested<N>> implements Nested<N>{
    NetworkDataNested(SecretStatus item) {
      this.builder = new SecretStatusBuilder(this, item);
    }
    SecretStatusBuilder builder;
    
    public N and() {
      return (N) PreprovisioningImageStatusFluent.this.withNetworkData(builder.build());
    }
    
    public N endNetworkData() {
      return and();
    }
    
  
  }

}