package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.model.SecretReference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class Metal3DataSpecFluent<A extends Metal3DataSpecFluent<A>> extends BaseFluent<A>{
  public Metal3DataSpecFluent() {
  }
  
  public Metal3DataSpecFluent(Metal3DataSpec instance) {
    this.copyInstance(instance);
  }
  private ObjectReferenceBuilder claim;
  private Integer index;
  private SecretReference metaData;
  private SecretReference networkData;
  private ObjectReferenceBuilder template;
  private String templateReference;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Metal3DataSpec instance) {
    instance = (instance != null ? instance : new Metal3DataSpec());
    if (instance != null) {
          this.withClaim(instance.getClaim());
          this.withIndex(instance.getIndex());
          this.withMetaData(instance.getMetaData());
          this.withNetworkData(instance.getNetworkData());
          this.withTemplate(instance.getTemplate());
          this.withTemplateReference(instance.getTemplateReference());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ObjectReference buildClaim() {
    return this.claim != null ? this.claim.build() : null;
  }
  
  public A withClaim(ObjectReference claim) {
    this._visitables.remove("claim");
    if (claim != null) {
        this.claim = new ObjectReferenceBuilder(claim);
        this._visitables.get("claim").add(this.claim);
    } else {
        this.claim = null;
        this._visitables.get("claim").remove(this.claim);
    }
    return (A) this;
  }
  
  public boolean hasClaim() {
    return this.claim != null;
  }
  
  public ClaimNested<A> withNewClaim() {
    return new ClaimNested(null);
  }
  
  public ClaimNested<A> withNewClaimLike(ObjectReference item) {
    return new ClaimNested(item);
  }
  
  public ClaimNested<A> editClaim() {
    return withNewClaimLike(java.util.Optional.ofNullable(buildClaim()).orElse(null));
  }
  
  public ClaimNested<A> editOrNewClaim() {
    return withNewClaimLike(java.util.Optional.ofNullable(buildClaim()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ClaimNested<A> editOrNewClaimLike(ObjectReference item) {
    return withNewClaimLike(java.util.Optional.ofNullable(buildClaim()).orElse(item));
  }
  
  public Integer getIndex() {
    return this.index;
  }
  
  public A withIndex(Integer index) {
    this.index = index;
    return (A) this;
  }
  
  public boolean hasIndex() {
    return this.index != null;
  }
  
  public SecretReference getMetaData() {
    return this.metaData;
  }
  
  public A withMetaData(SecretReference metaData) {
    this.metaData = metaData;
    return (A) this;
  }
  
  public boolean hasMetaData() {
    return this.metaData != null;
  }
  
  public A withNewMetaData(String name,String namespace) {
    return (A)withMetaData(new SecretReference(name, namespace));
  }
  
  public SecretReference getNetworkData() {
    return this.networkData;
  }
  
  public A withNetworkData(SecretReference networkData) {
    this.networkData = networkData;
    return (A) this;
  }
  
  public boolean hasNetworkData() {
    return this.networkData != null;
  }
  
  public A withNewNetworkData(String name,String namespace) {
    return (A)withNetworkData(new SecretReference(name, namespace));
  }
  
  public ObjectReference buildTemplate() {
    return this.template != null ? this.template.build() : null;
  }
  
  public A withTemplate(ObjectReference template) {
    this._visitables.remove("template");
    if (template != null) {
        this.template = new ObjectReferenceBuilder(template);
        this._visitables.get("template").add(this.template);
    } else {
        this.template = null;
        this._visitables.get("template").remove(this.template);
    }
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(ObjectReference item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(ObjectReference item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public String getTemplateReference() {
    return this.templateReference;
  }
  
  public A withTemplateReference(String templateReference) {
    this.templateReference = templateReference;
    return (A) this;
  }
  
  public boolean hasTemplateReference() {
    return this.templateReference != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Metal3DataSpecFluent that = (Metal3DataSpecFluent) o;
    if (!java.util.Objects.equals(claim, that.claim)) return false;
    if (!java.util.Objects.equals(index, that.index)) return false;
    if (!java.util.Objects.equals(metaData, that.metaData)) return false;
    if (!java.util.Objects.equals(networkData, that.networkData)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    if (!java.util.Objects.equals(templateReference, that.templateReference)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(claim,  index,  metaData,  networkData,  template,  templateReference,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (claim != null) { sb.append("claim:"); sb.append(claim + ","); }
    if (index != null) { sb.append("index:"); sb.append(index + ","); }
    if (metaData != null) { sb.append("metaData:"); sb.append(metaData + ","); }
    if (networkData != null) { sb.append("networkData:"); sb.append(networkData + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (templateReference != null) { sb.append("templateReference:"); sb.append(templateReference + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClaimNested<N> extends ObjectReferenceFluent<ClaimNested<N>> implements Nested<N>{
    ClaimNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) Metal3DataSpecFluent.this.withClaim(builder.build());
    }
    
    public N endClaim() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends ObjectReferenceFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) Metal3DataSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}